/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cqb.dc.services;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class Signature {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Signature.class);
    private static Signature sign = null;

    private Signature() {
    }

    public static synchronized Signature getInstance() {
        if (sign == null) {
            sign = new Signature();
        }
        return sign;
    }

    public Element sign(Element body) {
        String bodycontent = JDomUtils.element2StringPlain((Element)body, (String)RequestContextUtils.getCharset());
        logger.info("\u7b7e\u540d\u539f\u6587:" + bodycontent);
        bodycontent = bodycontent.replace("\r\n", "");
        bodycontent = bodycontent.replace("\n", "");
        bodycontent = this.setSignHeader(bodycontent) + bodycontent;
        String verifyIp = RequestContextUtils.getBankParameterValue((String)"ip");
        String verifyPort = RequestContextUtils.getBankParameterValue((String)"signPort");
        Integer port = Integer.parseInt(verifyPort);
        logger.info("\u91cd\u5e86\u94f6\u884c\u7b7e\u540d\u670d\u52a1ip:{},\u7aef\u53e3:{}", new Object[]{verifyIp, verifyPort});
        BufferedReader rd = null;
        Socket socket = null;
        FilterOutputStream out = null;
        try {
            socket = new Socket(verifyIp, (int)port);
            out = new DataOutputStream(socket.getOutputStream());
            out.write(bodycontent.getBytes("GBK"));
            rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            String returnStr = sb.toString();
            logger.info("\u7b7e\u540d\u6570\u636e\u8fd4\u56de\uff1a" + returnStr);
            Element root = Signature.string2Root(returnStr, RequestContextUtils.getCharset());
            Element head = root.getChild("head");
            String result = head.getChildText("result");
            String title = head.getChildText("title");
            if (!"0".equalsIgnoreCase(result)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"Signature_5", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), title));
            }
            Element signbody = root.getChild("body");
            String sign = signbody.getChildText("sign");
            Element newBody = new Element("body");
            JDomUtils.addChild((Element)newBody, (String)"signature", (String)sign);
            Element element = newBody;
            return element;
        }
        catch (IOException e) {
            logger.error("\u91cd\u5e86\u94f6\u884c\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91cd\u5e86\u94f6\u884c\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"Signature_1", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Element string2Root(String content, String encoding) throws EBServiceException {
        Document document = Signature.string2Document(content, encoding);
        return document.getRootElement();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document string2Document(String content, String encoding) throws EBServiceException {
        Document document;
        String data = content;
        int startPoint = content.indexOf("<html");
        if (-1 != startPoint) {
            content = content.substring(startPoint);
        }
        content = "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>" + content;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(content.getBytes(encoding));
            SAXBuilder builder = new SAXBuilder();
            document = builder.build((InputStream)bais);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5b57\u7b26\u96c6%1$s\u3002", (String)"Signature_6", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), encoding), (Throwable)e);
                catch (UTFDataFormatException e2) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u4e0d\u7b26,\u5b9e\u9645\u62a5\u6587\u5b57\u7b26\u96c6\u4e0d\u662f%1$s", (String)"Signature_7", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), encoding), (Throwable)e2);
                }
                catch (Exception e3) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u662fxml\u683c\u5f0f :%1$s\u3002", (String)"Signature_8", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]), data), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeInputStreamQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeInputStreamQuietly((InputStream)bais);
        return document;
    }

    private String setSignHeader(String signSrc) {
        int length = 0;
        try {
            length = signSrc.getBytes("gb18030").length;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7f16\u53f7");
        }
        logger.info("\u7b7e\u540d\u62a5\u6587Content-Length:{}", (Object)length);
        String header = "POST /servlet/CQBANK.Trans HTTP/1.1\r\nContent-Type: INFOSEC_SIGN/1.0\r\nContent-Length: " + length + "\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)\r\nHost: 127.0.0.1\r\n\r\n";
        return header;
    }
}

