/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class ParserRsp {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(ParserRsp.class);
    private static Map<String, String> statusCodesMap = new HashMap<String, String>(16);

    public static BankResponse parseRsp(String rspStr) {
        if (null == rspStr || rspStr.indexOf("</packet>") == -1) {
            String err = ResManager.loadKDString((String)"\u94f6\u884c\u53d1\u56de\u7684\u54cd\u5e94\u62a5\u6587\uff08\u7b7e\u540d\uff09\u683c\u5f0f\u9519\u8bef\uff0c\u6ca1\u6709\u4ee5'</packet>'\u7ed3\u5c3e\u3002", (String)"ParserRsp_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
            log.error(err);
            throw EBExceiptionUtil.serviceException((String)err);
        }
        BankResponse rsp = new BankResponse();
        int retcodeS = Check.getSignIndex(rspStr, "<returnCode>");
        int retcodeE = Check.getSignIndex(rspStr, "</returnCode>");
        String responseCode = rspStr.substring(retcodeS + "<returnCode>".length(), retcodeE);
        rsp.setResponseCode(responseCode);
        if (!"AAAAAAA".equalsIgnoreCase(responseCode)) {
            int retMsgS = Check.getSignIndex(rspStr, "<returnMsg>");
            int retMsgE = Check.getSignIndex(rspStr, "</returnMsg>");
            String responseMessage = rspStr.substring(retMsgS + "<returnMsg>".length(), retMsgE);
            rsp.setResponseMessage(responseMessage);
        } else {
            rsp.setResponseMessage("");
        }
        return rsp;
    }

    public static String getStatusMsg(String code) {
        return statusCodesMap.get(code);
    }

    static {
        statusCodesMap.put("0", ResManager.loadKDString((String)"\u672a\u5904\u7406\u6570\u636e\u6587\u4ef6\u3002", (String)"ParserRsp_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("1", ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u6570\u636e\u6587\u4ef6", (String)"ParserRsp_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("2", ResManager.loadKDString((String)"\u6570\u636e\u6587\u4ef6\u5904\u7406\u6210\u529f\u3002", (String)"ParserRsp_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("3", ResManager.loadKDString((String)"\u6570\u636e\u6587\u4ef6\u6709\u8bef\uff0c\u4e0d\u80fd\u8fdb\u884c\u3002", (String)"ParserRsp_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("4", ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e1a\u52a1\u6570\u636e\u3002", (String)"ParserRsp_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u5904\u7406\u6210\u529f\u3002", (String)"ParserRsp_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("6", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u5904\u7406\u5931\u8d25\u3002", (String)"ParserRsp_7", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("7", ResManager.loadKDString((String)"\u64a4\u9500", (String)"ParserRsp_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("E", ResManager.loadKDString((String)"\u901a\u8baf\u5931\u8d25", (String)"ParserRsp_9", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("G", ResManager.loadKDString((String)"\u4e3b\u673a\u62d2\u7edd", (String)"ParserRsp_10", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("H", ResManager.loadKDString((String)"\u7f51\u94f6\u62d2\u7edd", (String)"ParserRsp_11", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("I", ResManager.loadKDString((String)"\u6388\u6743\u62d2\u7edd", (String)"ParserRsp_12", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("J", ResManager.loadKDString((String)"\u4ea4\u6613\u5f55\u5165\uff0c\u5f85\u6388\u6743\u3002", (String)"ParserRsp_13", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("K", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ParserRsp_14", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("Y", ResManager.loadKDString((String)"\u4ea4\u6613\u63d0\u4ea4\u4e0d\u6210\u529f\u3002", (String)"ParserRsp_15", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        statusCodesMap.put("A", ResManager.loadKDString((String)"\u7b49\u5f85\u8fdb\u4e00\u6b65\u6388\u6743\u3002", (String)"ParserRsp_16", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
    }
}

