/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.balance.NoticeDepositBalanceParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
    public static final int queryNumber = 99;

    public String pack(BankBalanceRequest request) {
        if ("notice".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return this.packNoticeDepositBalance(request);
        }
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return this.packFixedBalance(request);
        }
        this.setLastPage(true);
        return this.packNormalTodayBalance(request);
    }

    public String packNoticeDepositBalance(BankBalanceRequest rqst) {
        int beginNumber = Integer.parseInt(this.getCurrentPage()) + 1;
        String beginNumberStr = String.valueOf(beginNumber);
        Element body = new Element("body");
        String transMasterID = BankBusinessConfig.getPayMasterID(rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transMasterID);
        JDomUtils.addChild((Element)body, (String)"status", (String)"0");
        JDomUtils.addChild((Element)body, (String)"queryType", (String)"0");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)beginNumberStr);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"99");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("FB20", signedMsg);
    }

    public String packFixedBalance(BankBalanceRequest rqst) {
        int beginNumber = Integer.parseInt(this.getCurrentPage()) + 1;
        String beginNumberStr = String.valueOf(beginNumber);
        Element body = new Element("body");
        String transMasterID = BankBusinessConfig.getPayMasterID(rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transMasterID);
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)beginNumberStr);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)String.valueOf(99));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("FT20", signedMsg);
    }

    private String packNormalTodayBalance(BankBalanceRequest rqst) {
        List bankAcntList = rqst.getBankAcntList();
        Element body = new Element("body");
        Element lists = JDomUtils.addChild((Element)body, (String)"lists");
        lists.setAttribute("name", "acctList");
        Element list = JDomUtils.addChild((Element)lists, (String)"list");
        bankAcntList.forEach(accNo -> JDomUtils.addChild((Element)list, (String)"acctNo", (String)StringLength.fixed((String)accNo.getAccNo(), (String)" ", (int)20, (boolean)false)));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("4402", signedMsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        this.setLastPage(true);
        if ("notice".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return NoticeDepositBalanceParser.parseNoticeDepositBalance(request, responseStr);
        }
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return this.parseFixedBalance(request, responseStr);
        }
        return this.parserNormalTodayBalance(request, responseStr);
    }

    public EBBankBalanceResponse parseFixedBalance(BankBalanceRequest rqst, String rspStr) {
        String balance;
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        Element lists = Check.checkNoNullChildElement(body, "lists");
        HashMap<String, String> balanceMap = new HashMap<String, String>(16);
        List localList = lists.getChildren("list");
        int length = localList.size();
        for (int i = 0; i < length; ++i) {
            Element e = (Element)localList.get(i);
            balance = e.getChildText("balance");
            String acctNo = e.getChildText("acctNo");
            balanceMap.put(acctNo, balance);
        }
        log.info("\u94f6\u884c\u8fd4\u56de" + length + "\u4e2a\u8d26\u6237\u4f59\u989d\u7ed3\u679c");
        BalanceInfo balanceInfo = new BalanceInfo();
        String accNo = rqst.getAcnt().getAccNo();
        balance = (String)balanceMap.get(accNo);
        if (!balance.isEmpty()) {
            BankAcnt acnt = new BankAcnt();
            acnt.setAccNo(accNo);
            balanceInfo.setBankAcnt(acnt);
            balanceInfo.setBankCurrency(rqst.getBankCurrency());
            this.setCurrentBalance(balanceInfo, balance);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        }
        if (length < 99) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8be5\u8d26\u53f7\u4f59\u989d\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        this.setLastPage(false);
        int nextTag = Integer.parseInt(this.getCurrentPage());
        this.setCurrentPage(nextTag += 99);
        ArrayList balances = new ArrayList(16);
        return new EBBankBalanceResponse(balances);
    }

    private EBBankBalanceResponse parserNormalTodayBalance(BankBalanceRequest rqst, String rspStr) {
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        int length = localList.size();
        log.info("\u94f6\u884c\u8fd4\u56de" + length + "\u4e2a\u8d26\u6237\u4f59\u989d\u7ed3\u679c");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(length);
        for (int i = 0; i < length; ++i) {
            Element element = (Element)localList.get(i);
            String acctNo = element.getChildTextTrim("acctNo");
            String masterID = element.getChildTextTrim("masterID");
            String balStr = element.getChildTextTrim("balance");
            String reserveBalance = element.getChildTextTrim("reserveBalance");
            String freezeBalance = element.getChildTextTrim("freezeBalance");
            String cortrolBalance = element.getChildTextTrim("cortrolBalance");
            String canUseBalance = element.getChildTextTrim("canUseBalance");
            String overdraftBalance = element.getChildTextTrim("overdraftBalance");
            BalanceInfo balance = new BalanceInfo();
            this.setBankAcnt(balance, rqst.getBankAcntList(), acctNo);
            this.setCurrentBalance(balance, balStr);
            this.setAvailableBalance(balance, canUseBalance);
            balance.setBalanceDateTime(LocalDateTime.now());
            balance.setBankCurrency(rqst.getBankCurrency());
            balances.add(balance);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"4.1 \u5e10\u6237\u4f59\u989d\u67e5\u8be2(4402)", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        if ("notice".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return true;
        }
        return "fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()));
    }
}

