/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(PayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return null;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "4605";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"4.8 \u96c6\u56e2\u5e10\u6237\u5f52\u96c6(4605)", (String)"PayImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return UseConvertor.isTransfer((PaymentInfo)info) && "pay".equalsIgnoreCase(info.getSubBizType()) && BankBusinessConfig.isTransferToCompany() == false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element body = new Element("body");
        PaymentInfo info = paymentInfos[0];
        boolean isTranUp = UseConvertor.isTransUp((PaymentInfo)paymentInfos[0]);
        JDomUtils.addChild((Element)body, (String)"payerAcctNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payerName", (String)info.getAccName());
        JDomUtils.addChild((Element)body, (String)"payeeAcctNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"payeeName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"transferType", (String)(true == isTranUp ? "0007" : "0008"));
        JDomUtils.addChild((Element)body, (String)"amount", (String)info.getAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)body, (String)"remarkNo", (String)info.getExplanation());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("4605", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String seqNo = body.getChildTextTrim("seqNo");
            String hintMsg = body.getChildTextTrim("hintMsg");
            log.info("\u94f6\u884c\u63a5\u53e3\u4e2d\u6ca1\u6709\u8fd4\u56de\u72b6\u6001\u4fe1\u606f\u3002\u672c\u6b21\u8fd4\u56de'\u67dc\u5458\u6d41\u6c34\u53f7':" + seqNo + ", '\u63d0\u793a\u4fe1\u606f':" + hintMsg);
            if (StringUtils.isEmpty((String)seqNo)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)hintMsg, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)hintMsg, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

