/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.batch;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.PayTimeUtils;
import kd.ebg.aqap.banks.spdb.dc.services.payment.batch.QueryBatchPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 400;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryBatchPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element body = new Element("body");
        if (BankBusinessConfig.isPayByAuthority().booleanValue()) {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)CommonUtils.getClientID(bankPayRequest.getAcnt().getAccNo()));
        } else {
            JDomUtils.addChild((Element)body, (String)"authMasterID", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"packageNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        Element lists = new Element("lists");
        lists.setAttribute("name", "PayList");
        JDomUtils.addChild((Element)body, (Element)lists);
        BigDecimal sumAmount = new BigDecimal("0");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            StringBuilder buffer = new StringBuilder();
            BigDecimal amount = ((PaymentInfo)paymentInfos.get(i)).getAmount();
            sumAmount = sumAmount.add(amount);
            Element list = new Element("list");
            String elecChequeNo = ((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqID();
            buffer.append(elecChequeNo).append("|");
            String acctNo = ((PaymentInfo)paymentInfos.get(i)).getAccNo();
            buffer.append(acctNo).append("|");
            String acctName = ((PaymentInfo)paymentInfos.get(i)).getAccName();
            buffer.append(acctName).append("|");
            if (null != ((PaymentInfo)paymentInfos.get(i)).getBookingTime() && ((PaymentInfo)paymentInfos.get(i)).getBookingTime().isAfter(LocalDateTime.now())) {
                buffer.append(((PaymentInfo)paymentInfos.get(i)).getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                PaymentUtil.setBookPayFlag((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            buffer.append("|");
            String payeeAcctNo = ((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo();
            buffer.append(payeeAcctNo).append("|");
            String payeeName = ((PaymentInfo)paymentInfos.get(i)).getIncomeAccName();
            buffer.append(payeeName).append("|");
            String payeeType = "0";
            if (((PaymentInfo)paymentInfos.get(i)).is2Individual()) {
                payeeType = "1";
            }
            buffer.append(payeeType).append("|");
            String sysFlag = "1";
            String remitLocation = "";
            if (((PaymentInfo)paymentInfos.get(i)).is2SameBank()) {
                sysFlag = "0";
                if (BankBusinessConfig.isSameCityTimeLimitOn().equals("3")) {
                    remitLocation = "1";
                }
            } else {
                remitLocation = BankBusinessConfig.isSameCityTimeLimitOn().equals("1") ? (((PaymentInfo)paymentInfos.get(i)).is2SameCity() && PayTimeUtils.isSameCityPayTime() ? "0" : "1") : (BankBusinessConfig.isSameCityTimeLimitOn().equals("2") ? (((PaymentInfo)paymentInfos.get(i)).is2SameCity() ? "0" : "1") : "1");
            }
            buffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeBankName()).append("|");
            buffer.append("").append("|");
            String amt = ((PaymentInfo)paymentInfos.get(i)).getAmount().setScale(2, 4).toString();
            buffer.append(amt).append("|");
            buffer.append(sysFlag).append("|");
            buffer.append(remitLocation).append("|");
            String note = CommonUtils.getExplanation((PaymentInfo)paymentInfos.get(i));
            buffer.append(note).append("|");
            String payeeBankSelectFlag = "1";
            String payeeBankNo = ((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps();
            buffer.append(payeeBankSelectFlag).append("|");
            buffer.append(payeeBankNo).append("|");
            String payPurpose = "";
            if (UseConvertor.isSalary((PaymentInfo)((PaymentInfo)paymentInfos.get(i)))) {
                payPurpose = "1";
            }
            buffer.append(payPurpose).append("|");
            JDomUtils.addChild((Element)list, (String)"detailedContent", (String)buffer.toString());
            JDomUtils.addChild((Element)lists, (Element)list);
        }
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)sumAmount.toString());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("8802", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse rsp = ParserRsp.parseRsp(rspStr);
        if ("EYY8968".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deEYY8968\uff0c\u4ea4\u6613\u5931\u8d25\u3002", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"BatchPayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(rspStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String acceptNo = ParserUtils.getUnNullElementTextValue((Element)body, (String)"acceptNo", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u53d7\u7406\u7f16\u53f7", (String)"BatchPayImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            if (StringUtils.isEmpty((String)acceptNo)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"BatchPayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)acceptNo, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u53d7\u7406\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u4ed8\u6b3e\u662f\u5426\u6210\u529f\u3002", (String)"BatchPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchPayImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)acceptNo, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchPayImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
                paymentInfos.forEach(paymentInfo -> paymentInfo.setBankRefID(acceptNo));
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "8802";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            return BankBusinessConfig.isUse8802ForSalary();
        }
        return false;
    }
}

