/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.newsalary;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "BBH3";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u6279\u91cf\u4ee3\u53d1\u4e1a\u52a1\u660e\u7ec6\u4e0b\u8f7d", (String)"QueryPayImpl_40", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        String unitNo;
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element body = new Element("body");
        String transMasterID = BankBusinessConfig.getPayTransNo(paymentInfo.getAccNo());
        if (StringUtils.isEmpty((String)transMasterID)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u4ea4\u6613\u5ba2\u6237\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_100", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transMasterID);
        if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            unitNo = BankBusinessConfig.getUnitNo(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_25", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
            JDomUtils.addChild((Element)body, (String)"costItemCode", (String)"1002");
        } else {
            unitNo = BankBusinessConfig.getUnitNoOther(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_26", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
            JDomUtils.addChild((Element)body, (String)"costItemCode", (String)"1001");
        }
        String transDate = "";
        transDate = paymentInfos[0].getSubmitSuccessTime() == null ? paymentInfos[0].getInsertTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : paymentInfos[0].getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"transDate", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"handleSeqNo", (String)Packer.getEntrustSeqNo(paymentInfos[0]));
        JDomUtils.addChild((Element)body, (String)"remark1", (String)"");
        JDomUtils.addChild((Element)body, (String)"remark2", (String)"");
        JDomUtils.addChild((Element)body, (String)"remark3", (String)"");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("BBH3", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String transStatus = body.getChildTextTrim("batchHandleStatus");
            String msg = ParserRsp.getStatusMsg(transStatus);
            if (!"0".equalsIgnoreCase(transStatus)) {
                if ("2".equalsIgnoreCase(transStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_23", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)msg);
                } else if ("1".equalsIgnoreCase(transStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)transStatus, (String)msg);
                } else if ("3".equalsIgnoreCase(transStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"QueryPayImpl_24", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)msg);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u72b6\u6001transStatus=%s\u3002", (String)"QueryPayImpl_31", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transStatus), (String)transStatus, (String)msg);
                }
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            log.info("\u51c6\u5907\u5f00\u59cb\u89e3\u6790\u4ed8\u6b3e\u660e\u7ec6");
            Element listsElement = body.getChild("lists");
            if (null == listsElement) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blists\u8282\u70b9,\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryPayImpl_102", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            List rdList = listsElement.getChildren("list");
            if (null == rdList || 0 == rdList.size()) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blists\u8282\u70b9,\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryPayImpl_102", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            for (int i = 0; i < rdList.size(); ++i) {
                Element rd = (Element)rdList.get(i);
                String detailedContent = rd.getChildText("detailedContent");
                String[] result = detailedContent.split("\\|");
                String payresult = result[0];
                String payeeAcctNo = result[1];
                String amount = result[2];
                String no = result[4];
                String message = result[6];
                PaymentInfo payment = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)no);
                if (null == payment) continue;
                if ("1".equals(payresult)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryBatchPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)message);
                    continue;
                }
                if ("0".equals(payresult)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryBatchPayImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)message);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5'\u4ea4\u6613\u72b6\u6001'\u7801'%s',\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"QueryBatchPayImpl_7", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), payresult), (String)transStatus, (String)"");
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

