/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opb.util.security;

import java.security.SecureRandom;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.params.KeyParameter;

public class SM4Util {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SM4Util.class);
    private static final int SM4_ENCRYPT = 1;
    private static final int SM4_DECRYPT = 0;
    public static final int SM4_PKCS7PADDING = 1;
    public static final int SM4_NOPADDING = 0;
    public static final int SM4_KEY_128 = 128;

    public static byte[] generateKey(int keySize) {
        byte[] key = new byte[keySize / 8];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(key);
        return key;
    }

    public static byte[] encryptECB(byte[] data, byte[] key) {
        return SM4Util.encryptECB(data, key, 1);
    }

    public static byte[] decryptECB(byte[] cipher, byte[] key) {
        return SM4Util.decryptECB(cipher, key, 1);
    }

    public static byte[] encryptECB(byte[] data, byte[] key, int paddingMode) {
        SM4Engine engine = new SM4Engine();
        engine.init(true, (CipherParameters)new KeyParameter(key));
        if (paddingMode == 1) {
            try {
                data = SM4Util.padding(data, 1, 7);
            }
            catch (Exception var7) {
                logger.error(var7.getMessage());
            }
        } else {
            try {
                data = SM4Util.padding(data, 1, 5);
            }
            catch (Exception var6) {
                logger.error(var6.getMessage());
            }
        }
        int length = data != null ? data.length : 0;
        int i = 0;
        while (length > 0) {
            engine.processBlock(data, i, data, i);
            length -= 16;
            i += 16;
        }
        return data;
    }

    public static byte[] decryptECB(byte[] cipher, byte[] key, int paddingMode) throws DataLengthException, IllegalStateException {
        SM4Engine engine = new SM4Engine();
        engine.init(false, (CipherParameters)new KeyParameter(key));
        int length = cipher.length;
        byte[] tmp = new byte[cipher.length];
        int i = 0;
        while (length > 0) {
            engine.processBlock(cipher, i, tmp, i);
            length -= 16;
            i += 16;
        }
        byte[] plain = null;
        if (paddingMode == 1) {
            try {
                plain = SM4Util.padding(tmp, 0, 7);
            }
            catch (Exception var9) {
                logger.info(var9.getMessage());
            }
        } else {
            try {
                plain = SM4Util.padding(tmp, 0, 5);
            }
            catch (Exception var8) {
                logger.info(var8.getMessage());
            }
        }
        return plain;
    }

    private static byte[] padding(byte[] input, int mode, int type) throws Exception {
        if (input == null) {
            return null;
        }
        byte[] ret = null;
        if (mode == 1) {
            switch (type) {
                case 5: {
                    if (input.length <= 0) {
                        throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\u3002PKCS6Padding\u586b\u5145\u6a21\u5f0f\u9519\u8bef\uff0c\u5b57\u8282\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"SM4Util_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]));
                    }
                    try {
                        int length = input.length;
                        int leftLength = 8 - (length % 8 == 0 ? 8 : length % 8);
                        byte[] arrayReturn = new byte[length + leftLength];
                        byte[] plusbyte = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
                        if (leftLength > 0) {
                            for (int i = 0; i < length + leftLength; ++i) {
                                arrayReturn[i] = i < length ? input[i] : plusbyte[leftLength];
                            }
                            ret = (byte[])arrayReturn.clone();
                            break;
                        }
                        ret = (byte[])input.clone();
                        break;
                    }
                    catch (Exception var9) {
                        throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0cPKCS5Padding\u586b\u5145\u6a21\u5f0f\u9519\u8bef\uff0c\u5f02\u5e38\u629b\u51fa\uff01", (String)"SM4Util_2", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), var9);
                    }
                }
                case 7: {
                    int length = 16 - input.length % 16;
                    ret = new byte[input.length + length];
                    System.arraycopy(input, 0, ret, 0, input.length);
                    for (int leftLength = 0; leftLength < length; ++leftLength) {
                        ret[input.length + leftLength] = (byte)length;
                    }
                    break;
                }
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }
}

