/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.payment.salary;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.glb.dc.services.payment.salary.QrySalaryPayImpl;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBParser;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryPayImpl.class);

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySalaryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getTransferInRequestBody(paymentInfos));
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        return "<?xml version=\"1.0\" encoding=\"" + RequestContextUtils.getCharset() + "\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element ebank_root = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ebank_root.getChild("head");
        Element body = ebank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"000000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        String errMsg = body.getChildTextTrim("errMsg");
        String status = body.getChildTextTrim("status");
        if ("90".equals(status)) {
            String batchNo = body.getChildTextTrim("batchNo");
            PaymentInfoSysFiled.set((PaymentInfo[])paymentInfos, (String)"batchNo", (String)batchNo);
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)"");
        } else if ("99".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)errMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE070710";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    private Element getTransferInRequestBody(PaymentInfo[] infos) {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"payAccount", (String)infos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"payMonth", (String)"202208");
        JDomUtils.addChild((Element)body, (String)"companyId", (String)"001");
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)BigDecimalHelper.plain2((BigDecimal)this.calcTotalAmt(infos)));
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)Integer.toString(infos.length));
        JDomUtils.addChild((Element)body, (String)"showDetail", (String)"0");
        Element list = JDomUtils.addChild((Element)body, (String)"list");
        for (PaymentInfo paymentInfo : infos) {
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"payAmount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"payRem", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)row, (String)"employeeId", (String)"123");
        }
        return body;
    }

    private BigDecimal calcTotalAmt(PaymentInfo[] paymentInfos) {
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos[i].getAmount());
        }
        return total;
    }
}

