/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GLBTransforQueryParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GLBTransforQueryParser.class);

    public static void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) {
        Element ebenk = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = ebenk.getChild("head");
        if (!"000000".equals(head.getChildTextTrim("retCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de:%s", (String)"GLBTransforQueryParser_4", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), head.getChildText("retMessage"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ebenk.getChild("body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"list");
        List Elements = list.getChildren("row");
        Map<String, String> result = GLBTransforQueryParser.getResultFromBank(Elements);
        for (PaymentInfo paymentInfo : paymentInfos) {
            String key = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"orderFlowNo");
            if (!StringUtils.isEmpty((String)key)) {
                String status = result.get(key);
                if ("90".equalsIgnoreCase(status)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"GLBTransforQueryParser_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"GLBTransforQueryParser_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("99".equalsIgnoreCase(status) || "91".equalsIgnoreCase(status) || "71".equalsIgnoreCase(status) || "92".equalsIgnoreCase(status)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"GLBTransforQueryParser_2", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"GLBTransforQueryParser_2", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"GLBTransforQueryParser_3", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"GLBTransforQueryParser_3", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"GLBTransforQueryParser_3", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"GLBTransforQueryParser_3", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
        }
    }

    public static Map<String, String> getResultFromBank(List<Element> elements) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        for (Element element : elements) {
            String orderFlowNo = JDomUtils.getChildTextTrim((Element)element, (String)"orderFlowNo");
            String orderState = JDomUtils.getChildTextTrim((Element)element, (String)"orderState");
            map.put(orderFlowNo, orderState);
        }
        return map;
    }
}

