/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjrcb.cmp.services.balance;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjrcb.cmp.services.Parser;
import kd.ebg.aqap.banks.bjrcb.cmp.utils.DateUtil;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest request, String rspMsg) throws EBServiceException {
        Element body;
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        BankAcnt bankAcnt = request.getAcnt();
        balanceInfo.setBankAcnt(bankAcnt);
        Document rspXml = Parser.parseReceiveMsg2Doc(rspMsg);
        Element head = rspXml.getRootElement().getChild("head");
        String ret_code = head.getChildText("ret_code");
        if (ret_code.equals("0000")) {
            body = rspXml.getRootElement().getChild("body");
            String resMsg = "";
            if (!body.getChildText("acno").equalsIgnoreCase(request.getAcnt().getAccNo())) {
                resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u6c42\u67e5\u8be2\u7684\u8d26\u6237\uff08%1$s\uff09\u548c\u8fd4\u56de\u7ed3\u679c\u7684\u8d26\u6237\uff08%2$s\uff09\u4e0d\u4e00\u81f4", (String)"TodayBalanceParser_6", (String)"ebg-aqap-banks-bjrcb-cmp", (Object[])new Object[0]), request.getAcnt().getAccNo(), body.getChildText("acno"));
                throw EBExceiptionUtil.serviceException((String)resMsg);
            }
            String balance = body.getChildText("balance");
            String use_balance = body.getChildText("use_balance");
            if (!StringUtils.isNotEmpty((String)balance)) {
                resMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d\u5b57\u6bb5\uff08balance\uff09\u89e3\u6790\u4e3a\u7a7a\u503c", (String)"TodayBalanceParser_8", (String)"ebg-aqap-banks-bjrcb-cmp", (Object[])new Object[0]);
                throw EBExceiptionUtil.serviceException((String)resMsg);
            }
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
            if (StringUtils.isNotEmpty((String)use_balance)) {
                balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
            }
        } else {
            String ret_msg = head.getChildText("ret_info");
            String ret_extMsg = head.getChildText("ext_info");
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\uff0c\u9644\u52a0\u4fe1\u606f\uff1a%3$s\u3002", (String)"TodayBalanceParser_7", (String)"ebg-aqap-banks-bjrcb-cmp", (Object[])new Object[0]), ret_code, ret_msg, ret_extMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        String currency = body.getChildText("cur_code");
        balanceInfo.setBankCurrency(currency == null ? request.getBankCurrency() : currency);
        balanceInfo.setBalanceDateTime(DateUtil.dateTolocalDateTime(new Date()));
        balanceRsp.setBalances(Collections.singletonList(balanceInfo));
        return balanceRsp;
    }
}

