/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.myccb.dc.services.payment.salary;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.myccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.myccb.dc.services.Common;
import kd.ebg.aqap.banks.myccb.dc.services.Packer;
import kd.ebg.aqap.banks.myccb.dc.services.detail.RespFileUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if ("200201".equals(BankBusinessConfig.salaryChoose())) {
            return this.pack200201(paymentInfos);
        }
        return this.pack200100(paymentInfos);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String content;
        List infos = bankPayRequest.getPaymentInfos();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-myccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(infos);
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570=%1$s\u3002", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-myccb-dc", (Object[])new Object[0]), record_num), (String)"", (String)"");
            return new EBBankPayResponse(infos);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        if ("1".equals(file_flag)) {
            this.log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = RespFileUtils.getInstance().getRspFileData(file_name);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-myccb-dc", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            this.log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        this.log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u7684\u5177\u4f53\u5185\u5bb9\uff1a" + content);
        String[][] rs = this.parseRecord(content, recordNum, fieldNum);
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 0; i < rs.length; ++i) {
            String ACNO = rs[i][1];
            String ACNAME = rs[i][3];
            String AMT = rs[i][5];
            String STAT = rs[i][9];
            String ERR_MSG = rs[i][10];
            String BATCH_NO = rs[i][11];
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(ACNO, ACNAME, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);
            if ("9".equalsIgnoreCase(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("6".equalsIgnoreCase(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("3".equalsIgnoreCase(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)infos.get(0)).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
    }

    private PaymentInfo findPaymentInfo(List<PaymentInfo> infos, String BATCH_NO, String ACNO, String ACNAME, String AMT) {
        String packageId = infos.get(0).getPackageId();
        for (PaymentInfo pay : infos) {
            if (!packageId.equals(BATCH_NO) || !pay.getIncomeAccNo().equals(ACNO) || !pay.getIncomeAccName().equals(ACNAME) || !pay.getAmount().toPlainString().equals(AMT)) continue;
            return pay;
        }
        return null;
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        this.log.info("###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201/200100";
    }

    public String getBizDesc() {
        return null;
    }

    private String pack200201(PaymentInfo[] paymentInfos) {
        String tr_code = "200201";
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[0], (String)"SerialNo");
        LocalDateTime submitSuccessTime = paymentInfos[0].getSubmitSuccessTime();
        if (StringUtils.isEmpty((String)serial_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7serial_no\u4e3a\u7a7a\u3002", (String)"QueryPayImpl_7", (String)"ebg-aqap-banks-myccb-dc", (Object[])new Object[0]));
        }
        if (submitSuccessTime == null) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671ftr_acdt\u4e3a\u7a7a\u3002", (String)"QueryPayImpl_8", (String)"ebg-aqap-banks-myccb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfos[0].getPackageId());
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String time = RequestContextUtils.getParameter().getBankParameter("testTime");
        if (StringUtils.isEmpty((String)time)) {
            time = submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)time);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    private String pack200100(PaymentInfo[] paymentInfos) {
        String tr_code = "200100";
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        String time = RequestContextUtils.getParameter().getBankParameter("testTime");
        if (StringUtils.isEmpty((String)time)) {
            LocalDateTime submitSuccessTime = paymentInfos[0].getSubmitSuccessTime();
            if (submitSuccessTime == null) {
                throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671fstart_date\uff0cend_date\u4e3a\u7a7a\u3002", (String)"QueryPayImpl_9", (String)"ebg-aqap-banks-myccb-dc", (Object[])new Object[0]));
            }
            time = submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        JDomUtils.addChild((Element)body, (String)"start_date", (String)time);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)time);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

