/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.services.TxStatusType;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BOCHK_DC_Parser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BOCHK_DC_Parser.class);

    public static BankResponse parseHead(Element root) {
        BankResponse rsp = new BankResponse();
        Element head = root.getChild("Head");
        String TxStatus2 = head.getChildTextTrim("TxStatus");
        rsp.setResponseCode(TxStatus2);
        TxStatusType txStatusType = TxStatusType.getTxStatusTypeById(TxStatus2);
        String TxStatusMsg = "";
        TxStatusMsg = txStatusType != null ? txStatusType.getTypeMsg() : String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u975e\u6b63\u5e38\u54cd\u5e94\u7801%s\u3002", (String)"BOCHK_DC_Parser_7", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), TxStatus2);
        rsp.setResponseMessage(TxStatusMsg);
        return rsp;
    }

    public static void overseaParsePay(List<PaymentInfo> paymentInfos, String rspStr, String transCode) {
        try {
            Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            BankResponse bankRsp = BOCHK_DC_Parser.parseHead(root);
            if ("F".equals(bankRsp.getResponseCode()) || "R".equals(bankRsp.getResponseCode())) {
                BOCHK_DC_Parser.trySetErrMsg(root, paymentInfos, transCode);
                return;
            }
            if (!"S".equals(bankRsp.getResponseCode())) {
                String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
                String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"BOCHK_DC_Parser_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ErrorCode, (String)ErrorDesc);
                return;
            }
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"BOCHK_DC_Parser_1", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u8be5\u7b14\u4ea4\u6613\u72b6\u6001\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u64cd\u4f5c\u3002", (String)"BOCHK_DC_Parser_2", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            List requestList = root.getChild("Tx").getChild("TransferRLY").getChild("Requests").getChildren();
            for (int i = 0; i < requestList.size(); ++i) {
                String RecordStatus;
                String actualAmountStr;
                Element record = (Element)requestList.get(i);
                Element fps = record.getChild(transCode);
                if (null == fps) continue;
                PaymentInfo info = paymentInfos.get(i);
                String amountStr = JDomUtils.getChildText((Element)fps, (String)"EquvAmt");
                if (!StringUtils.isEmpty((String)amountStr)) {
                    info.setAmount(new BigDecimal(amountStr));
                }
                if (!StringUtils.isEmpty((String)(actualAmountStr = JDomUtils.getChildText((Element)fps, (String)"DebitAmt")))) {
                    info.setActualAmount(new BigDecimal(actualAmountStr));
                }
                if ("S".equals(RecordStatus = fps.getChildTextTrim("RecordStatus"))) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCHK_DC_Parser_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)RecordStatus, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCHK_DC_Parser_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
                    continue;
                }
                String RecordErrorCode = fps.getChildTextTrim("RecordErrorCode");
                String RecordErrorDesc = fps.getChildTextTrim("RecordErrorDesc");
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BOCHK_DC_Parser_4", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)RecordErrorCode, (String)RecordErrorDesc);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u53d1\u751f\u5f02\u5e38\u3002", (String)"BOCHK_DC_Parser_5", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
        }
    }

    public static void trySetErrMsg(Element root, List<PaymentInfo> paymentInfos, String transCode) {
        String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
        String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
        EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BOCHK_DC_Parser_6", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), (String)ErrorCode, (String)ErrorDesc);
        Element Tx = root.getChild("Tx");
        if (Tx != null) {
            Element Requests = Tx.getChild("TransferRLY").getChild("Requests");
            List requestList = Requests.getChildren();
            int min = Math.min(requestList.size(), paymentInfos.size());
            for (int i = 0; i < min; ++i) {
                Element record = (Element)requestList.get(i);
                Element InternalTrans = record.getChild(transCode);
                if (null == InternalTrans) continue;
                String RecordStatus = InternalTrans.getChildTextTrim("RecordStatus");
                String RecordErrorDesc = InternalTrans.getChildTextTrim("RecordErrorDesc");
                paymentInfos.get(i).setBankStatus(RecordStatus);
                paymentInfos.get(i).setBankMsg(ErrorDesc + "-" + RecordStatus + "\uff1a" + RecordErrorDesc);
            }
        }
    }
}

