/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPay_Packer {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryPay_Packer.class);

    public static String createTransferEnquiryREQ(PaymentInfo[] paymentInfos) {
        Element BOCHKE2B = BOCHK_DC_Packer.createRootWithHead(BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = new Element("Tx");
        Element TransferEnquiryREQ = new Element("TransferEnquiryREQ");
        JDomUtils.addChild((Element)TransferEnquiryREQ, (String)"EnqPackageId", (String)paymentInfos[0].getPackageId());
        String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        if (!StringUtils.isEmpty((String)testServerDate)) {
            LocalDate parseDate = LocalDate.parse(testServerDate, DateTimeFormatter.BASIC_ISO_DATE);
            testServerDate = parseDate.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        }
        JDomUtils.addChild((Element)TransferEnquiryREQ, (String)"TxDate", (String)(StringUtils.isEmpty((String)testServerDate) ? paymentInfos[0].getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")) : testServerDate));
        JDomUtils.addChild((Element)Tx, (Element)TransferEnquiryREQ);
        JDomUtils.addChild((Element)BOCHKE2B, (Element)Tx);
        String requestMessage = JDomUtils.root2String((Element)BOCHKE2B, (String)RequestContextUtils.getCharset());
        log.info("\u3010\u67e5\u8a62\u8f49\u8cec\u3011\u8acb\u6c42\u5831\u6587\uff1a" + requestMessage);
        return requestMessage;
    }

    public static String createOvrsTransEnqREQ(PaymentInfo[] paymentInfos) {
        Element BOCHKE2B = BOCHK_DC_Packer.createRootWithHead(BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = new Element("Tx");
        Element OvrsTransEnqREQ = new Element("OvrsTransEnqREQ");
        JDomUtils.addChild((Element)OvrsTransEnqREQ, (String)"EnqPackageId", (String)paymentInfos[0].getPackageId());
        JDomUtils.addChild((Element)OvrsTransEnqREQ, (String)"TxDate", (String)paymentInfos[0].getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
        JDomUtils.addChild((Element)Tx, (Element)OvrsTransEnqREQ);
        JDomUtils.addChild((Element)BOCHKE2B, (Element)Tx);
        String requestMessage = JDomUtils.root2String((Element)BOCHKE2B, (String)RequestContextUtils.getCharset());
        log.info("\u3010\u67e5\u8a62\u6d77\u5916\u8f49\u8cec\u3011\u8acb\u6c42\u5831\u6587\uff1a" + requestMessage);
        return requestMessage;
    }
}

