/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.utils;

import java.util.Vector;

public final class Base64 {
    private static int MEMUNIT = 1024;
    private static int MAXLINELEN = 76;
    private static byte[] base64Alphabet = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte pad = (byte)61;
    private static byte cr = (byte)13;
    private static byte lf = (byte)10;
    private Vector vBuffer = new Vector(MEMUNIT, MEMUNIT);
    private byte[] byLeft = new byte[4];
    private int nLeft;
    private boolean bEndOfDecode;

    public Base64() {
        this.byLeft[3] = 0;
        this.byLeft[2] = 0;
        this.byLeft[1] = 0;
        this.byLeft[0] = 0;
        this.nLeft = 0;
        this.bEndOfDecode = false;
    }

    public void decode(byte[] byInput, int nInputLength) {
        int i;
        if (this.bEndOfDecode) {
            return;
        }
        int nNewLength = nInputLength + this.nLeft;
        byte[] byNewInput = new byte[nNewLength];
        for (i = 0; i < this.nLeft; ++i) {
            byNewInput[i] = this.byLeft[i];
        }
        int j = 0;
        while (j < nInputLength) {
            byNewInput[i] = byInput[j];
            ++j;
            ++i;
        }
        byte[] byBuffer = new byte[4];
        int nBuffer = 0;
        for (i = 0; i < nNewLength && !this.bEndOfDecode; ++i) {
            int j2;
            if (nBuffer < 4) {
                if (this.getReverseMapping(byNewInput[i]) >= 0) {
                    byBuffer[nBuffer++] = byNewInput[i];
                    if (nBuffer < 4) {
                        continue;
                    }
                } else {
                    if (byNewInput[i] != pad) continue;
                    this.bEndOfDecode = true;
                    if (nBuffer == 0 || nBuffer == 1) {
                        nBuffer = 0;
                        continue;
                    }
                }
            }
            int n = 0;
            for (j2 = 0; j2 < nBuffer; ++j2) {
                n = (n << 6) + (this.getReverseMapping(byBuffer[j2]) & 0x3F);
            }
            while (j2 < 4) {
                n <<= 6;
                ++j2;
            }
            if (nBuffer == 4) {
                this.vBuffer.addElement((byte)(n >> 16 & 0xFF));
                this.vBuffer.addElement((byte)(n >> 8 & 0xFF));
                this.vBuffer.addElement((byte)(n & 0xFF));
            } else if (nBuffer == 3) {
                this.vBuffer.addElement((byte)(n >> 16 & 0xFF));
                this.vBuffer.addElement((byte)(n >> 8 & 0xFF));
            } else {
                this.vBuffer.addElement((byte)(n >> 16 & 0xFF));
            }
            nBuffer = 0;
        }
        if (!this.bEndOfDecode) {
            for (i = 0; i < nBuffer; ++i) {
                this.byLeft[i] = byBuffer[i];
            }
            this.nLeft = nBuffer;
        } else {
            this.nLeft = 0;
        }
    }

    public void encode(byte[] byInput, int nInputLength) {
        int i;
        if (nInputLength == 0) {
            return;
        }
        int nNewInputLength = this.nLeft + nInputLength;
        byte[] byNewInput = new byte[nNewInputLength];
        for (i = 0; i < this.nLeft; ++i) {
            byNewInput[i] = this.byLeft[i];
        }
        for (int j = 0; j < nInputLength; ++j) {
            byNewInput[i] = byInput[j];
            ++i;
        }
        i = 0;
        while (i + 2 < nNewInputLength) {
            int n = ((byNewInput[i] & 0xFF) << 16) + ((byNewInput[i + 1] & 0xFF) << 8) + (byNewInput[i + 2] & 0xFF);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 18 & 0x3F)]);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 12 & 0x3F)]);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 6 & 0x3F)]);
            this.vBuffer.addElement(base64Alphabet[(byte)(n & 0x3F)]);
            i += 3;
        }
        this.nLeft = 0;
        while (i < nNewInputLength) {
            this.byLeft[this.nLeft] = byNewInput[i];
            ++i;
            ++this.nLeft;
        }
    }

    public void endDecode() {
        if (this.nLeft > 1 && this.nLeft < 4) {
            int j;
            int n = 0;
            for (j = 0; j < this.nLeft; ++j) {
                n = (n << 6) + (this.getReverseMapping(this.byLeft[j]) & 0x3F);
            }
            while (j < 4) {
                n <<= 6;
                ++j;
            }
            if (this.nLeft == 3) {
                this.vBuffer.addElement((byte)(n >> 16 & 0xFF));
                this.vBuffer.addElement((byte)(n >> 8 & 0xFF));
            } else {
                this.vBuffer.addElement((byte)(n >> 16 & 0xFF));
            }
        }
        this.nLeft = 0;
        this.bEndOfDecode = true;
    }

    public void endEncode() {
        if (this.nLeft == 1) {
            int n = (this.byLeft[0] & 0xFF) << 16;
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 18 & 0x3F)]);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 12 & 0x3F)]);
            this.vBuffer.addElement(pad);
            this.vBuffer.addElement(pad);
        } else if (this.nLeft == 2) {
            int n = ((this.byLeft[0] & 0xFF) << 16) + ((this.byLeft[1] & 0xFF) << 8);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 18 & 0x3F)]);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 12 & 0x3F)]);
            this.vBuffer.addElement(base64Alphabet[(byte)(n >> 6 & 0x3F)]);
            this.vBuffer.addElement(pad);
        }
    }

    public byte[] getDecodedResult() {
        int size = this.vBuffer.size();
        byte[] byTemp = new byte[size];
        for (int i = 0; i < size; ++i) {
            byTemp[i] = (Byte)this.vBuffer.elementAt(i);
        }
        return byTemp;
    }

    public byte[] getEncodedResult() {
        int size = this.vBuffer.size();
        if (size == 0) {
            return new byte[0];
        }
        byte[] byTemp = new byte[size + (size - 1) / MAXLINELEN * 2];
        int j = 0;
        int i = 0;
        while (i < size) {
            byTemp[j++] = (Byte)this.vBuffer.elementAt(i++);
            if (i % MAXLINELEN != 0 || i >= size) continue;
            byTemp[j++] = cr;
            byTemp[j++] = lf;
        }
        return byTemp;
    }

    private byte getReverseMapping(byte by) {
        int n = base64Alphabet.length;
        for (int i = 0; i < n; ++i) {
            if (by != base64Alphabet[i]) continue;
            return (byte)i;
        }
        return -1;
    }

    public void startDecode() {
        this.vBuffer.removeAllElements();
        this.byLeft[2] = 0;
        this.byLeft[1] = 0;
        this.byLeft[0] = 0;
        this.nLeft = 0;
        this.bEndOfDecode = false;
    }

    public void startEncode() {
        this.vBuffer.removeAllElements();
        this.byLeft[2] = 0;
        this.byLeft[1] = 0;
        this.byLeft[0] = 0;
        this.nLeft = 0;
    }

    public byte[] decode(byte[] src) {
        int k = 0;
        int n = 0;
        byte[] dst = new byte[src.length];
        for (int i = 0; i < src.length; i += 4) {
            int j;
            n = 0;
            byte l = 0;
            for (j = 0; j < 4 && (l = this.getReverseMapping(src[i + j])) != -1; ++j) {
                n = (n << 6) + l;
            }
            if (j == 4) {
                dst[k++] = (byte)(n >> 16 & 0xFF);
                dst[k++] = (byte)(n >> 8 & 0xFF);
                dst[k++] = (byte)(n & 0xFF);
                continue;
            }
            if (j == 3) {
                dst[k++] = (byte)((n <<= 6) >> 16 & 0xFF);
                dst[k++] = (byte)(n >> 8 & 0xFF);
                break;
            }
            if (j != 2) continue;
            dst[k++] = (byte)((n <<= 12) >> 16 & 0xFF);
            break;
        }
        byte[] tmp = new byte[k];
        System.arraycopy(dst, 0, tmp, 0, k);
        return tmp;
    }

    public byte[] encode(byte[] src) {
        int k = 0;
        int n = 0;
        int len = src.length;
        byte[] dst = new byte[len * 2];
        int i = 0;
        while (i + 2 < len) {
            n = (src[i] & 0xFF) << 16;
            n += (src[i + 1] & 0xFF) << 8;
            dst[k++] = base64Alphabet[(n += src[i + 2] & 0xFF) >> 18 & 0x3F];
            dst[k++] = base64Alphabet[n >> 12 & 0x3F];
            dst[k++] = base64Alphabet[n >> 6 & 0x3F];
            dst[k++] = base64Alphabet[n & 0x3F];
            i += 3;
        }
        if (len % 3 == 2) {
            n = (src[i] & 0xFF) << 16;
            dst[k++] = base64Alphabet[(n += (src[i + 1] & 0xFF) << 8) >> 18 & 0x3F];
            dst[k++] = base64Alphabet[n >> 12 & 0x3F];
            dst[k++] = base64Alphabet[n >> 6 & 0x3F];
            dst[k++] = pad;
        } else if (len % 3 == 1) {
            n = (src[i] & 0xFF) << 16;
            dst[k++] = base64Alphabet[n >> 18 & 0x3F];
            dst[k++] = base64Alphabet[n >> 12 & 0x3F];
            dst[k++] = pad;
            dst[k++] = pad;
        }
        byte[] retBuf = new byte[k];
        System.arraycopy(dst, 0, retBuf, 0, k);
        return retBuf;
    }
}

