/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.utils;

public class SHA1 {
    long count = 0L;
    long[] state = new long[5];
    int[] buffer = new int[64];
    long SHA1_K0;
    long SHA1_K1;
    long SHA1_K2;
    long SHA1_K3;

    public SHA1() {
        this.state[0] = 1732584193L;
        this.state[1] = 4023233417L;
        this.state[2] = 2562383102L;
        this.state[3] = 271733878L;
        this.state[4] = 3285377520L;
        this.SHA1_K0 = 1518500249L;
        this.SHA1_K1 = 1859775393L;
        this.SHA1_K2 = 2400959708L;
        this.SHA1_K3 = 3395469782L;
    }

    public int bytetoint(byte data) {
        int res = data;
        if (res < 0) {
            res += 256;
        }
        return res;
    }

    public byte[] end() {
        int i;
        byte[] digest = new byte[20];
        int[] counts = new int[8];
        int n = (int)(this.count & 0x3FL);
        this.count <<= 3;
        for (i = 7; i >= 0; --i) {
            counts[i] = (int)(this.count & 0xFFL);
            this.count >>>= 8;
        }
        if (n >= 56) {
            this.buffer[n] = 128;
            for (i = ++n; i < 64; ++i) {
                this.buffer[i] = 0;
            }
            this.transform();
            for (i = 0; i < 56; ++i) {
                this.buffer[i] = 0;
            }
            for (i = 0; i < 8; ++i) {
                this.buffer[i + 56] = counts[i];
            }
            this.transform();
        } else {
            this.buffer[n] = 128;
            for (i = ++n; i < 56; ++i) {
                this.buffer[i] = 0;
            }
            for (i = 0; i < 8; ++i) {
                this.buffer[i + 56] = counts[i];
            }
            this.transform();
        }
        for (i = 0; i < 5; ++i) {
            long l = this.state[i];
            for (int j = 3; j >= 0; --j) {
                int m = (int)(l & 0xFFL);
                digest[i * 4 + j] = this.inttobyte(m);
                l >>>= 8;
            }
            this.state[i] = 0L;
        }
        return digest;
    }

    public void init() {
        this.count = 0L;
        this.state[0] = 1732584193L;
        this.state[1] = 4023233417L;
        this.state[2] = 2562383102L;
        this.state[3] = 271733878L;
        this.state[4] = 3285377520L;
        this.SHA1_K0 = 1518500249L;
        this.SHA1_K1 = 1859775393L;
        this.SHA1_K2 = 2400959708L;
        this.SHA1_K3 = 3395469782L;
    }

    public byte inttobyte(int data) {
        byte res = data >= 128 ? (byte)(data - 256) : (byte)data;
        return res;
    }

    public long ROTL(long data, int n) {
        long res = data << n | data >>> 32 - n;
        return res &= 0xFFFFFFFFL;
    }

    public void transform() {
        long temp;
        int i;
        int i2;
        long[] w = new long[80];
        for (int i3 = 0; i3 < 16; ++i3) {
            w[i3] = 0L;
        }
        int j = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            w[j] = w[j] << 8 | (long)(this.buffer[i2] & 0xFF);
            if (i2 % 4 != 3) continue;
            ++j;
        }
        for (i2 = 16; i2 < 80; ++i2) {
            long temp2 = w[i2 - 3] ^ w[i2 - 8] ^ w[i2 - 14] ^ w[i2 - 16];
            w[i2] = this.ROTL(temp2, 1);
        }
        long a = this.state[0];
        long b = this.state[1];
        long c = this.state[2];
        long d = this.state[3];
        long e = this.state[4];
        for (i = 0; i < 20; ++i) {
            temp = this.ROTL(a, 5);
            temp = temp + (b & c | (b ^ 0xFFFFFFFFFFFFFFFFL) & d) + e + w[i] + this.SHA1_K0;
            e = d;
            d = c;
            c = this.ROTL(b, 30);
            b = a;
            a = temp &= 0xFFFFFFFFL;
        }
        for (i = 20; i < 40; ++i) {
            temp = this.ROTL(a, 5);
            temp = temp + (b ^ c ^ d) + e + w[i] + this.SHA1_K1;
            e = d;
            d = c;
            c = this.ROTL(b, 30);
            b = a;
            a = temp &= 0xFFFFFFFFL;
        }
        for (i = 40; i < 60; ++i) {
            temp = this.ROTL(a, 5);
            temp = temp + (b & c | c & d | d & b) + e + w[i] + this.SHA1_K2;
            e = d;
            d = c;
            c = this.ROTL(b, 30);
            b = a;
            a = temp &= 0xFFFFFFFFL;
        }
        for (i = 60; i < 80; ++i) {
            temp = this.ROTL(a, 5);
            temp = temp + (b ^ c ^ d) + e + w[i] + this.SHA1_K3;
            e = d;
            d = c;
            c = this.ROTL(b, 30);
            b = a;
            a = temp &= 0xFFFFFFFFL;
        }
        this.state[0] = this.state[0] + a & 0xFFFFFFFFL;
        this.state[1] = this.state[1] + b & 0xFFFFFFFFL;
        this.state[2] = this.state[2] + c & 0xFFFFFFFFL;
        this.state[3] = this.state[3] + d & 0xFFFFFFFFL;
        this.state[4] = this.state[4] + e & 0xFFFFFFFFL;
        for (i = 0; i < 80; ++i) {
            w[i] = 0L;
        }
    }

    public void Update(byte[] data, long length) {
        int k;
        int n = (int)(this.count & 0x3FL);
        this.count += length;
        int l = 64 - n;
        int pos = 0;
        while ((long)l <= length) {
            for (k = n; k < 64; ++k) {
                this.buffer[k] = this.bytetoint(data[pos]);
                ++pos;
            }
            this.transform();
            n = 0;
            l += 64;
        }
        n = (int)(this.count & 0x3FL);
        for (k = 0; k < n; ++k) {
            this.buffer[k] = this.bytetoint(data[pos]);
            ++pos;
        }
    }
}

