/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.dc.utils.FileTransUtil;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HSBC_DC_Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HSBC_DC_Parser.class);

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"HSBC_DC_Parser_0", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public static EBBankPayResponse parsePayResponse(BankPayRequest request, String responseStr) {
        if (PropertiesConstants.getValue((String)"SUCCESS").equalsIgnoreCase(responseStr)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.SUBMITTING, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_DC_Parser_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_DC_Parser_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_DC_Parser_16", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        } else if (PropertiesConstants.getValue((String)"FAIL").equalsIgnoreCase(responseStr)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"HSBC_DC_Parser_17", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"HSBC_DC_Parser_17", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u4e0a\u4f20\u5230\u94f6\u884c\u5931\u8d25\u3002", (String)"HSBC_DC_Parser_18", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"HSBC_DC_Parser_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"HSBC_DC_Parser_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"HSBC_DC_Parser_19", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public static EBBankPayResponse parseQueryPayResponse(BankPayRequest request, String responseStr) {
        File[] tarrFiles;
        File[] arrFiles;
        String[] ackDirs = StringUtils.split((String)responseStr, (String)"|");
        String ackDir = ackDirs[0];
        String transAckDir = ackDirs[1];
        File ackDirFile = FileCommonUtils.getFileByPath((String)ackDir);
        for (File file : arrFiles = ackDirFile.listFiles()) {
            String response = FileTransUtil.fileToString(file);
            Element root = JDomUtils.string2Root((String)response, (String)EBContext.getContext().getCharsetName());
            Element cstrpt = JDomUtils.getChildElementNotNull((Element)root, (String)"CstmrPmtStsRpt");
            Element grphdr = JDomUtils.getChildElementNotNull((Element)cstrpt, (String)"GrpHdr");
            String msgId = grphdr.getChildText("MsgId");
            Element orgnlpst = JDomUtils.getChildElementNotNull((Element)cstrpt, (String)"OrgnlPmtInfAndSts");
            String OrgnlPmtInfId = JDomUtils.getChildTextNotNull((Element)orgnlpst, (String)"OrgnlPmtInfId");
            List txinfList = orgnlpst.getChildren("TxInfAndSts");
            Map<String, String> resultMap = HSBC_DC_Parser.getResultMap(txinfList);
            List payInfoList = PaymentInfoService.getInstance().selectByBatchSeqID(OrgnlPmtInfId);
            for (PaymentInfo gen : payInfoList) {
                String status = resultMap.get(gen.getBankBatchSeqID());
                if (StringUtils.isEmpty((String)status)) continue;
                if ("RJCT".equalsIgnoreCase(status)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)gen, (PaymentState)PaymentState.FAIL, (String)"", (String)"", (String)"");
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)gen, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
            }
            if (FileTransUtil.cutFile(file, file.getParent())) {
                logger.info("\u79fb\u52a8\u6587\u4ef6\uff1a\u6210\u529f");
                continue;
            }
            logger.info("\u79fb\u52a8\u6587\u4ef6\uff1a\u5931\u8d25");
        }
        File transAckDirFile = FileCommonUtils.getFileByPath((String)transAckDir);
        for (File file : tarrFiles = transAckDirFile.listFiles()) {
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private static Map<String, String> getResultMap(List<Element> results) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        for (Element node : results) {
            String stsId = node.getChildText("OrgnlEndToEndId");
            String txStatus = node.getChildText("TxSts");
            resultMap.put(stsId, txStatus);
        }
        return resultMap;
    }
}

