/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service.payment.oversea.ach;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Packer;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Parser;
import kd.ebg.aqap.banks.hsbc.dc.service.payment.oversea.HSBC_DC_CommonPacker;
import kd.ebg.aqap.banks.hsbc.dc.service.payment.oversea.ach.QueryPaymentImpl;
import kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public int getBatchSize() {
        return BankBusinessConfig.getBatchNumber();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String connectCustomerID = RequestContextUtils.getBankParameterValue((String)"CONNECT_CUSTOMER_ID");
        Element simulator = new Element("simulator");
        Element head = HSBC_DC_Packer.createHead("XML");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        if (BankBusinessConfig.isWebservice()) {
            JDomUtils.addChild((Element)reqPara, (String)"uploadMethod", (String)"ws");
        } else {
            JDomUtils.addChild((Element)reqPara, (String)"uploadMethod", (String)"ftp");
        }
        String content = this.packPayXmlACH(paymentInfos, connectCustomerID);
        String bankMsg = Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
        JDomUtils.addChild((Element)body, (String)"bankMsg", (String)bankMsg);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String packPayXmlACH(List<PaymentInfo> paymentInfos, String connectCustomerID) {
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = HSBC_DC_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn, connectCustomerID);
        Element PmtInf = HSBC_DC_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)info.getActualAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(info.getActualAmount());
            InstdAmt.setAttribute("Ccy", info.getPayCurrency());
            if (info.getPayerFeeType().equalsIgnoreCase("01")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("02")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if (info.getPayerFeeType().equalsIgnoreCase("03")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)info.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
            }
            if (!StringUtils.isEmpty((String)info.getIncomeBankLocalClearingCode())) {
                Element ClrSysMmbId = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"ClrSysMmbId").setNamespace(ns1);
                JDomUtils.addChild((Element)ClrSysMmbId, (String)"MmbId", (String)info.getIncomeBankLocalClearingCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)info.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            String benefitBankAddress = info.getIncomeBankAddress();
            PaymentUtil.addressSplit(CdtrAgt_FinInstnId_PstlAdr, benefitBankAddress);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6%s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5339\u914d\u56fd\u5bb6\u4ee3\u7801\u8868\u3002", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)PaymentUtil.formatStringByLength(info.getIncomeAccName(), 100)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            PaymentUtil.addressSplit(Cdtr_PstlAdr, info.getIncomeAddress());
            code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6%s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5339\u914d\u56fd\u5bb6\u4ee3\u7801\u8868\u3002", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)info.getIncomeAccNo()).setNamespace(ns1);
            String payPurpose = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"payPurpose");
            if (!StringUtils.isEmpty((String)payPurpose)) {
                Element Purp = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Purp").setNamespace(ns1);
                JDomUtils.addChild((Element)Purp, (String)"Cd", (String)payPurpose).setNamespace(ns1);
            }
            if (StringUtils.isEmpty((String)info.getExplanation())) continue;
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)info.getExplanation()).setNamespace(ns1);
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = HSBC_DC_Parser.parseHeader(root);
        if ("BIZ_FAIL".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5217\u8868\u4e3a\u7a7a\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String sequence = JDomUtils.getChildTextTrim((Element)list, (String)"sequence");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)sequence);
            if (null == info) continue;
            if ("BCC_PAY_SUBMT_SUCCESS".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-hsbc-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

