/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.opa.service.apply.ApplyImpl;
import kd.ebg.aqap.banks.gdb.opa.service.apply.QueryApplyImpl;
import kd.ebg.aqap.banks.gdb.opa.service.balance.BalanceImpl;
import kd.ebg.aqap.banks.gdb.opa.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.gdb.opa.service.detail.DetailImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyFunItem;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class GDBOPAMetaDataImpl
extends OPAMetaDataTemplate {
    public static final String BANK_VERSION_ID = "GDB_OPA";
    public static final String CST_NO = "cst_no";

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c", (String)"GDBOPAMetaDataImpl_0", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        this.setBankVersionID(BANK_VERSION_ID);
        this.setBankShortName("GDB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c\u5f00\u653e\u5e73\u53f0\u7248", (String)"GDBOPAMetaDataImpl_1", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5e7f\u4e1c\u53d1\u5c55\u94f6\u884c", (String)"GDBOPAMetaDataImpl_2", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5e7f\u53d1\u94f6\u884c", (String)"GDBOPAMetaDataImpl_0", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e7f\u4e1c\u53d1\u5c55\u94f6\u884c", (String)"GDBOPAMetaDataImpl_2", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0])}));
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        String exchangeProtocol;
        int port;
        String host;
        if ("prod".equals(System.getProperty("ebg.server.env"))) {
            host = "ebank.cgbchina.com.cn";
            port = 443;
            exchangeProtocol = "HTTPS";
        } else {
            host = "ebank-yd02.test.cgbchina.com.cn";
            port = 38083;
            exchangeProtocol = "HTTPS";
        }
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)"ip", (String)ResManager.loadKDString((String)"\u670d\u52a1\u7f51\u5173\u5730\u5740", (String)"GDBOPAMetaDataImpl_3", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e3aebank.cgbchina.com.cn\uff0c\u6d4b\u8bd5\u73af\u5883\u4e3a218.13.4.182", (String)"GDBOPAMetaDataImpl_4", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)host, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"exchangePort", (String)ResManager.loadKDString((String)"\u670d\u52a1\u7aef\u53e3", (String)"GDBOPAMetaDataImpl_5", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e3a443\uff0c\u6d4b\u8bd5\u73af\u5883\u4e3a38083", (String)"GDBOPAMetaDataImpl_6", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)String.valueOf(port), (boolean)false, (boolean)false).set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)).set2MaxValueNum(65535), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeProtocol", (String)ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"GDBOPAMetaDataImpl_7", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u9009\u62e9https\uff0c\u6d4b\u8bd5\u73af\u5883\u9009\u62e9http", (String)"GDBOPAMetaDataImpl_8", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), Arrays.asList("HTTPS", "HTTP"), (String)exchangeProtocol, (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"timeout", (String)ResManager.loadKDString((String)"\u8d85\u65f6\u8bbe\u7f6e(min)", (String)"GDBOPAMetaDataImpl_9", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)"3").set2InputType(ConfigInputType.INTEGER.getInputType()).set2MinValueNum(Integer.valueOf(0)), BankLoginConfigUtil.getBankLoginConfig((String)"charset", (String)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6", (String)"GDBOPAMetaDataImpl_10", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)"UTF-8").set2ReadOnly()});
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)CST_NO, (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u5ba2\u6237\u53f7", (String)"GDBOPAMetaDataImpl_13", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u7f51\u94f6\u5ba2\u6237\u53f7", (String)"GDBOPAMetaDataImpl_14", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true)});
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)PrivateKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u79c1\u94a5\u6587\u4ef6", "GDBOPAMetaDataImpl_15", "ebg-aqap-banks-gdb-opa"), (String)"", (boolean)false, (boolean)false, (String)"upload"), BankLoginConfigUtil.getMlBankLoginConfig((String)PublicKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u516c\u94a5\u6587\u4ef6", "GDBOPAMetaDataImpl_16", "ebg-aqap-banks-gdb-opa"), (String)"", (boolean)false, (boolean)false, (String)"upload")});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{ApplyImpl.class, QueryApplyImpl.class, BalanceImpl.class, HisBalanceImpl.class, DetailImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public List<BankPropertyFunItem> getBankPropertyFunItems() {
        return Lists.newArrayList((Object[])new BankPropertyFunItem[]{BankPropertyFunItem.builder().key(BizName.DETAIL.name()).name(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"GDBOPAMetaDataImpl_17", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u76f8\u5173\u7684\u63a5\u53e3\uff0c\u5305\u62ec\u5386\u53f2\u660e\u7ec6\uff0c\u5f53\u65e5\u660e\u7ec6", (String)"GDBOPAMetaDataImpl_18", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0])).funStr("acctTrxDetailQuery").build(), BankPropertyFunItem.builder().key(BizName.BALANCE.name()).name(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d", (String)"GDBOPAMetaDataImpl_19", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5b9e\u65f6\u4f59\u989d\u63a5\u53e3", (String)"GDBOPAMetaDataImpl_20", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0])).funStr("acctHisBalanceQuery,acctBalanceQuery").build()});
    }

    public void baseConfigInit() {
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("hostDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("hostTrxId", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

