/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.util;

import com.alibaba.fastjson.JSONObject;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opa.util.Base64;
import kd.ebg.aqap.banks.gdb.opa.util.Parser;
import kd.ebg.aqap.banks.gdb.opa.util.security.RSAUtils;
import kd.ebg.aqap.banks.gdb.opa.util.security.SM4Util;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.common.utils.gdbopa.Hex;
import kd.ebg.aqap.common.utils.gdbopa.SM2Util;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;

public class SMUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SMUtil.class);

    public static Map<String, String> buildSendParam(String originalMsg, boolean needSign, String encoding) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            String oriReqStr = originalMsg;
            logger.info("\u8bf7\u6c42\u62a5\u6587\u539f\u6587\uff1a\n" + oriReqStr);
            String entSignature = "";
            if (needSign) {
                entSignature = Hex.encode((byte[])SM2Util.sign((byte[])Hex.decode((String)SMUtil.getUserPrivateKey()), (byte[])oriReqStr.getBytes()));
                logger.info("\u4f01\u4e1a\u7b7e\u540d\u7ed3\u679c\uff1a\n" + entSignature);
                result.put("entSignature", entSignature);
            }
            byte[] signDigest = RSAUtils.sha1X16(oriReqStr + entSignature, encoding);
            String signature = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])RSAUtils.signBySoft(SMUtil.getPlateFormPrivateKey(), signDigest)));
            logger.info("\u91d1\u8776\u7b7e\u540d\u7ed3\u679c\uff1a\n" + signature);
            byte[] sm4keyByte = SM4Util.generateKey(128);
            String sm4Key = Hex.encode((byte[])sm4keyByte);
            String msg = Hex.encode((byte[])SM4Util.encryptECB(oriReqStr.getBytes(), sm4keyByte));
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(1, SMUtil.getPublicKey());
            String encryptKey = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])cipher.doFinal(sm4keyByte)), encoding);
            result.put("signature", signature);
            result.put("msg", msg);
            result.put("encryptKey", encryptKey);
        }
        catch (Exception e) {
            logger.info("\u52a0\u5bc6\u6216\u7b7e\u540d\u5931\u8d25\uff1a", (Object)e.getMessage());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u52a0\u5bc6\u6216\u7b7e\u540d\u5931\u8d25:", (String)"SMUtil_0", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        return result;
    }

    public static String getReceMsg(String resp, String encryptKey, String encoding) {
        try {
            if (resp.contains("sysRetCode")) {
                JSONObject jsonObject = JSONObject.parseObject((String)resp);
                Parser.parseHeader(jsonObject, "");
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(2, SMUtil.getPlateFormPrivateKey());
            byte[] sm4keyByte = cipher.doFinal(org.apache.commons.codec.binary.Base64.decodeBase64((byte[])encryptKey.getBytes(encoding)));
            String sm4Key = Hex.encode((byte[])sm4keyByte);
            String respStr = new String(SM4Util.decryptECB(Hex.decode((String)resp), sm4keyByte));
            logger.info("\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\u7ed3\u679c\uff1a\n" + respStr);
            return respStr;
        }
        catch (Exception e) {
            logger.info("\u89e3\u5bc6\u5931\u8d25\uff1a", (Object)e.getMessage());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u5931\u8d25:%s", (String)"SMUtil_7", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static String getUserPublicKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(OPAMetaDataTemplate.PublicKey, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            return "";
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return CipherInfoUtil.getKey((byte[])fileContent);
    }

    private static String getUserPrivateKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(OPAMetaDataTemplate.PrivateKey, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u7528\u6237\u79c1\u94a5\u8bc1\u4e66", (String)"SMUtil_2", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return CipherInfoUtil.getKey((byte[])fileContent);
    }

    private static PrivateKey getPlateFormPrivateKey() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_private_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u7528\u6237\u79c1\u94a5\u8bc1\u4e66", (String)"SMUtil_2", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String privateKeyStr = CipherInfoUtil.getKey((byte[])fileContent);
        try {
            return SMUtil.getPrivateKeyFromBytes(privateKeyStr, "PKCS");
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u83b7\u53d6\u79d8\u94a5\u5931\u8d25", (String)"SMUtil_3", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        }
    }

    private static PublicKey getPublicKey() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66", (String)"SMUtil_4", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]));
        }
        return SMUtil.getPublicKey(certInfo.getFileContent(), certInfo.getCustomID(), certInfo.getCertID());
    }

    public static PrivateKey getPrivateKeyFromBytes(String crtBase64, String type) {
        try {
            byte[] baKey = Base64.decode(crtBase64);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(type.equalsIgnoreCase("PKCS") ? new PKCS8EncodedKeySpec(baKey) : new X509EncodedKeySpec(baKey));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u79c1\u94a5\u5931\u8d25%s", (String)"SMUtil_8", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static PublicKey getPublicKey(String data, String customID, String certID) {
        try {
            CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)data);
            byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)customID, (int)cipherInfo.getCipherVersion(), (String)certID);
            String publicKeystr = CipherInfoUtil.getKey((byte[])fileContent);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(kd.ebg.egf.common.framework.frontProxy.Base64.decode((String)publicKeystr));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6publicKey\u5931\u8d25%s", (String)"SMUtil_9", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

