/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import kd.ebg.aqap.banks.gdb.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.opa.util.MyX509TrustManager;
import kd.ebg.aqap.banks.gdb.opa.util.SMUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.http.util.CharArrayBuffer;

public class SendUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SendUtil.class);

    public static String send(String bizCode, String originalMsg) {
        String encoding = RequestContextUtils.getCharset();
        String appid = BankBusinessConfig.getGdbAppId();
        Map<String, String> param = SMUtil.buildSendParam(originalMsg, !"serviceApplyAuth".equalsIgnoreCase(bizCode), encoding);
        String url = SendUtil.getUrl(bizCode);
        return SendUtil.doPostForm(url, param, appid, encoding);
    }

    private static String getUrl(String bizCode) {
        String exchangeProtocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        String port = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        port = "HTTPS".equalsIgnoreCase(exchangeProtocol) && "443".equalsIgnoreCase(port) ? "" : ":" + port;
        String url = exchangeProtocol + "://" + RequestContextUtils.getBankParameterValue((String)"ip") + port + "/deib/P5DEIB/P501/" + bizCode + "/1.0.0";
        logger.info("\u8bbf\u95ee\u7684\u94f6\u884c\u5730\u5740\u4e3a\uff1a{}", (Object)url);
        return url;
    }

    public static String doPostForm(String httpUrl, Map<String, String> param, String appid, String encoding) throws EBServiceException {
        String result;
        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        try {
            int l;
            String entSignature;
            URL url = new URL(httpUrl);
            SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
            sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
            HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslsession) {
                    return s.equalsIgnoreCase(sslsession.getPeerHost());
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            logger.info("\u5efa\u7acb\u8fde\u63a5");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setInstanceFollowRedirects(true);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "text/plain;charset=UTF-8");
            connection.setRequestProperty("appId", appid);
            String signature = param.get("signature");
            if (StringUtils.isNotEmpty((String)signature)) {
                connection.setRequestProperty("signature", param.get("signature"));
            }
            if (StringUtils.isNotEmpty((String)(entSignature = param.get("entSignature")))) {
                connection.setRequestProperty("entSignature", param.get("entSignature"));
            }
            connection.setRequestProperty("encryptKey", param.get("encryptKey"));
            os = connection.getOutputStream();
            os.write(param.get("msg").getBytes());
            if (connection.getResponseCode() != 200) {
                String temp;
                is = connection.getErrorStream();
                br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                StringBuilder sbf = new StringBuilder();
                while ((temp = br.readLine()) != null) {
                    sbf.append(temp);
                    sbf.append("\r\n");
                }
                String result2 = sbf.toString();
                EBContext.getContext().setType("response");
                logger.info("\u975e\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)result2);
                EBContext.getContext().setType(null);
                throw EBExceiptionUtil.serviceException((String)result2);
            }
            is = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            int capacity = connection.getContentLength();
            logger.info("\u5185\u5bb9\u957f\u5ea6\uff1a" + capacity);
            if (capacity == -1) {
                capacity = 1024;
            }
            CharArrayBuffer buffer = new CharArrayBuffer(capacity);
            char[] tmp = new char[1024];
            while ((l = br.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            result = buffer.toString();
            String encryptKeyResp = connection.getHeaderField("encryptKey");
            EBContext.getContext().setType("response");
            logger.info("\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)result);
            result = SMUtil.getReceMsg(result, encryptKeyResp, encoding);
            EBContext.getContext().setType(null);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }
}

