/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static int size = 100;

    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        LoginUtils.login();
        Element root = new Element("Transaction");
        String pageNo = this.getCurrentPage();
        boolean isStartPage = "0".equals(pageNo);
        if (isStartPage) {
            this.setCurrentPage("1");
        }
        Element header = CommonPacker.createSystemHead(this.getBizCode(), size + "", isStartPage ? "1" : pageNo, isStartPage ? "" : (String)EBContext.getContext().getRunningParams().get("STS_TRACE_ID"));
        root.addContent((Content)header);
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element request = CommonPacker.packInfoComEntity();
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        list1.setAttribute("type", "G");
        JDomExtUtils.addChildCDData(list1, "AccNo", bankDetailRequest.getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "StDt", LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate(), (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "EdDt", LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate(), (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "CcyCd", bankDetailRequest.getBankCurrency());
        return JDomExtUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(rspStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        rspStr = bankResponse.getBankMsg();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s", (String)"DetailImpl_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        EBContext.getContext().getRunningParams().put("STS_TRACE_ID", bankResp.getStsTraceId());
        this.setPageParam(bankResp.getTotalPage());
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String rcrdNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        List detaiList = response.getChildren("LIST1");
        if (!"0".equalsIgnoreCase(rcrdNum)) {
            for (Element node : detaiList) {
                String remark;
                String bankDetailSeqId;
                DetailInfo info = new DetailInfo();
                String AccNo = JDomExtUtils.getChildText((Element)node, (String)"AccNo");
                String txDt = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dt");
                String txTm = JDomExtUtils.getChildText((Element)node, (String)"Txn_Tm");
                String detailNo = JDomExtUtils.getChildText((Element)node, (String)"Txn_Dtl_No");
                String dbtCrDrcCd = JDomExtUtils.getChildText((Element)node, (String)"DbtCrDrcCd");
                String dhamount = JDomExtUtils.getChildText((Element)node, (String)"DHAmt");
                String cramount = JDomExtUtils.getChildText((Element)node, (String)"Cr_HpnAm");
                String ExoStm_Py_Rmrk = JDomExtUtils.getChildText((Element)node, (String)"ExoStm_Py_Rmrk");
                String Bnk_Only1_ID_ID = JDomExtUtils.getChildText((Element)node, (String)"Bnk_Only1_ID_ID");
                String Amount = "";
                String CstPty_Py_Jrnl_No = JDomExtUtils.getChildText((Element)node, (String)"CstPty_Py_Jrnl_No");
                if (!request.getAcnt().getAccNo().equals(AccNo)) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0e\u8fd4\u56de\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4", (String)"DetailImpl_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), AccNo));
                }
                if (StringUtils.isEmpty((String)txTm)) {
                    txTm = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
                }
                txTm = txDt + txTm;
                info.setTransDate(LocalDate.parse(txTm, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                info.setTransTime(LocalDateTime.parse(txTm, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                if (!StringUtils.isEmpty((String)dhamount)) {
                    info.setDebitAmount(new BigDecimal(dhamount));
                    Amount = dhamount;
                }
                if (!StringUtils.isEmpty((String)cramount)) {
                    info.setCreditAmount(new BigDecimal(cramount));
                    Amount = cramount;
                }
                info.setAccNo(request.getHeader().getAcnt().getAccNo());
                info.setAccName(request.getHeader().getAcnt().getAccName());
                String currency = JDomExtUtils.getChildText((Element)node, (String)"CcyCd");
                info.setCurrency(currency);
                String orAccNo = JDomExtUtils.getChildText((Element)node, (String)"CntprtAcc");
                info.setOppAccNo(orAccNo);
                String orAccName = JDomExtUtils.getChildText((Element)node, (String)"Cntrprt_AccNm");
                info.setOppAccName(orAccName);
                String bankSequnce = JDomExtUtils.getChildText((Element)node, (String)"CCBS_TxnSrlNo");
                if (!StringUtils.isEmpty((String)CstPty_Py_Jrnl_No) && CstPty_Py_Jrnl_No.startsWith("KD_")) {
                    bankDetailSeqId = CstPty_Py_Jrnl_No.substring("KD_".length());
                    info.setKdFlag(bankDetailSeqId);
                    info.setPayBankDetailSeqID(bankDetailSeqId);
                }
                if (!StringUtils.isEmpty((String)ExoStm_Py_Rmrk) && ExoStm_Py_Rmrk.startsWith("KD_")) {
                    bankDetailSeqId = ExoStm_Py_Rmrk.substring("KD_".length());
                    info.setKdFlag(bankDetailSeqId);
                    info.setPayBankDetailSeqID(bankDetailSeqId);
                }
                String Smy_Cd = JDomExtUtils.getChildText((Element)node, (String)"Smy_Cd");
                String Smy = JDomExtUtils.getChildText((Element)node, (String)"Smy");
                String cadbankNm = JDomExtUtils.getChildText((Element)node, (String)"CADBank_Nm");
                if (!StringUtils.isEmpty((String)cadbankNm)) {
                    info.setOppBankName(cadbankNm);
                }
                if (StringUtils.isEmpty((String)(remark = JDomExtUtils.getChildText((Element)node, (String)"Rmrk")))) {
                    info.setExplanation(Smy);
                } else {
                    info.setExplanation(remark);
                }
                String bal = JDomExtUtils.getChildText((Element)node, (String)"AcBa");
                if (!StringUtils.isEmpty((String)bal)) {
                    info.setBalance(new BigDecimal(bal));
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(node);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("Amount", (Object)Amount);
                jsonStr = jsonObject.toJSONString();
                String transDateStr = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(request.getHeader().getAcnt().getAccNo(), transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                info.setJsonMap(jsonStr);
                info.setBankDetailNo(Bnk_Only1_ID_ID);
                result.add(info);
            }
        }
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        detailResponse.setDetails(result);
        return detailResponse;
    }

    private void setPageParam(String totalPageStr) {
        int totalPage;
        int currencyPage = Integer.parseInt(this.getCurrentPage());
        if (currencyPage >= (totalPage = Integer.parseInt(totalPageStr))) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(currencyPage + 1);
        }
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSER65";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6d3b\u671f\u8d26\u6237\u660e\u7ec6", (String)"DetailImpl_3", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }
}

