/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uob.dc.services.payment;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uob.dc.services.Api;
import kd.ebg.aqap.banks.uob.dc.utils.UOBUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            String requestStr = this.pack(request);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            String response = UOBUtil.request((HttpRequestBase)new HttpGet(UOBUtil.url(Api.QUERY_PAYMENT.getName())), UOBUtil.generateJWT(requestStr));
            return this.parse(request, response);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject root = new JSONObject();
        JSONObject transaction = new JSONObject();
        transaction.put("transactionReference", (Object)paymentInfo.getBankDetailSeqID());
        LocalDateTime insertTime = paymentInfo.getInsertTime();
        String transactionDate = insertTime.format(DateTimeFormatter.ofPattern("ddMMyyyy"));
        transaction.put("transactionDate", (Object)transactionDate);
        JSONObject account = new JSONObject();
        account.put("accountNumber", (Object)paymentInfo.getAccNo());
        account.put("accountCurrency", (Object)paymentInfo.getCurrency());
        account.put("accountType", (Object)BankAcntPropertyConfig.getAccType((String)paymentInfo.getAccNo()));
        transaction.put("account", (Object)account);
        JSONObject paymentAmount = new JSONObject();
        paymentAmount.put("currency", (Object)paymentInfo.getCurrency());
        paymentAmount.put("amount", (Object)paymentInfo.getAmount());
        transaction.put("paymentAmount", (Object)paymentAmount);
        root.put("transaction", (Object)transaction);
        String r = root.toJSONString();
        logger.info("Payload\u4e3a{}", (Object)r);
        return r;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject root = JSONObject.parseObject((String)s);
        JSONObject transactionStatus = root.getJSONObject("transactionStatus");
        if (transactionStatus == null) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\u4fe1\u606f\u3002", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]));
        } else {
            String code = transactionStatus.getString("code");
            String description = transactionStatus.getString("description");
            if ("000000".equalsIgnoreCase(code)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)code, (String)description);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)description);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

