/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EBGLogger.class);
    private static final int pageSize = 50;

    public String pack(BankDetailRequest bankDetailRequest) {
        String pageTag = this.getCurrentPage();
        if ("0".equals(pageTag)) {
            pageTag = "1";
            this.setCurrentPage(pageTag);
        }
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element root = CommonPacker.packHeader(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"DOC_PG_NO", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"DOC_PG_SIZE", (String)"50");
        JDomUtils.addChild((Element)body, (String)"TX_ACCT_NO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"TX_ACCT_NM", (String)acnt.getAccName());
        JDomUtils.addChild((Element)body, (String)"CUR_CD", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"BGN_DT", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"END_DT", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate()));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse response = CommonParser.parserHead(root);
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        if ("Z00002".equals(response.getResponseCode()) || "D00100".equals(response.getResponseCode())) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801{}\uff0c\u8868\u793a\u65e0\u8bb0\u5f55\uff0c\u4e0d\u62a5\u9519\uff0c\u4e0d\u89e3\u6790\uff0c\u76f4\u63a5\u8fd4\u56de\u7a7a\u8bb0\u5f55", (Object)response.getResponseCode());
            this.setLastPage(true);
            return new EBBankDetailResponse(detailInfoList);
        }
        if (!"000000".equals(response.getResponseCode())) {
            this.setLastPage(true);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff0c\u62a5\u6587\u8fd4\u56de\u72b6\u6001\uff1a%1$s\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = root.getChild("BODY");
        if (!this.isLastPage(body)) {
            int nextPageTag = Integer.parseInt(this.getCurrentPage()) + 1;
            this.setCurrentPage(nextPageTag);
        } else {
            this.setLastPage(true);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        Element list = JDomUtils.getChildElement((Element)body, (String)"LOOP");
        List details = list.getChildren("DETAIL");
        for (int i = 0; i < details.size(); ++i) {
            Element record = (Element)details.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(JDomUtils.getChildText((Element)record, (String)"TX_ACCT_NO"));
            detail.setAccName(JDomUtils.getChildText((Element)record, (String)"TX_ACCT_NM"));
            detail.setCurrency(JDomUtils.getChildText((Element)record, (String)"CUR_CD"));
            String balanceStr = JDomUtils.getChildText((Element)record, (String)"CURR_BAL");
            if (StringUtils.isNotEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr));
            }
            String cdFlag = JDomUtils.getChildText((Element)record, (String)"DEBIT_CRDT_FLG_CD");
            String amt = JDomUtils.getChildText((Element)record, (String)"TX_AMT");
            if ("2".equals(cdFlag)) {
                detail.setCreditAmount(new BigDecimal(amt));
                detail.setDebitAmount(new BigDecimal(0));
            } else if ("1".equals(cdFlag)) {
                detail.setCreditAmount(new BigDecimal(0));
                detail.setDebitAmount(new BigDecimal(amt));
            }
            detail.setOppAccNo(JDomUtils.getChildText((Element)record, (String)"TX_OPPNNT_ACCT_NO"));
            detail.setOppAccName(JDomUtils.getChildText((Element)record, (String)"TX_OPPNNT_ACCT_NM"));
            detail.setOppBankName(JDomUtils.getChildText((Element)record, (String)"TSFIN_OPEN_ACCT_ORG_NM"));
            String dateStr = JDomUtils.getChildText((Element)record, (String)"SERV_PTY_TX_DT");
            String timeStr = JDomUtils.getChildText((Element)record, (String)"SERV_PTY_TX_TM");
            try {
                detail.setTransDate(LocalDateUtil.parserDate((String)dateStr));
                detail.setTransTime(LocalDateTime.parse(dateStr + " " + timeStr, DateTimeFormatter.ofPattern("yyyyMMdd HHmmss")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u683c\u5f0f\u9519\u8bef\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]), (Throwable)e);
            }
            detail.setExplanation(JDomUtils.getChildText((Element)record, (String)"ABST_INFO"));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("oppAccNo", (Object)detail.getOppAccNo());
            jsonObject.put("Amount", (Object)amt);
            jsonObject.put("cdFlag", (Object)cdFlag);
            jsonObject.put("serialNo", (Object)JDomUtils.getChildText((Element)record, (String)"KEPACCT_SN"));
            String receiptNo = MatchRule.getInstance().getReceiptNo(detail.getAccNo(), dateStr, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(JDomUtils.getChildText((Element)record, (String)"KEPACCT_SN"));
            detailInfoList.add(detail);
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean isLastPage(Element body) {
        String pageNo = body.getChildText("DOC_PG_NO");
        String countSize = body.getChildText("DTL_KEPRCD_QTY");
        String num = body.getChildText("KEPRCD_QTY");
        int retRecords = Integer.parseInt(StringUtils.isEmpty((String)num) ? "0" : num);
        if (retRecords < 50) {
            this.logger.info("\u5f53\u524d\u7b14\u6570\u5c0f\u4e8e{}\uff0c\u4e3a\u6700\u540e\u4e00\u9875", (Object)50);
            return true;
        }
        int pageMaxNum = Integer.parseInt(pageNo) * 50;
        if (pageMaxNum >= Integer.parseInt(countSize)) {
            this.logger.info("\u9875\u7801\u4e58\u4ee5\u9875\u6570\u7b49\u4e8e{}\uff0c\u5927\u4e8e\u6216\u7b49\u4e8e\u660e\u7ec6\u603b\u6570{}\uff0c\u4e3a\u6700\u540e\u4e00\u9875", new Object[]{pageMaxNum, countSize});
            return true;
        }
        return false;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "TC005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\uff0c\u5f53\u65e5\u660e\u7ec6", (String)"DetailImpl_2", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }
}

