/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.payment.allocation;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryTransferImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryTransferImpl.class);
    private static final String TRANCODE = "B2EFundcollectRecordDetailQry";

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead(TRANCODE, info.getBankBatchSeqId()));
        Element body = new Element("Body");
        String batchNo = PaymentInfoSysFiled.get((PaymentInfo)info, (String)"BatchNo");
        ZZB_Packer.checkSynNo(batchNo);
        JDomUtils.addChild((Element)body, (String)"BatchNo", (String)batchNo);
        JDomUtils.addChild((Element)body, (String)"PageSize", (String)"50");
        JDomUtils.addChild((Element)body, (String)"PageIndex", (String)"1");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)ebank_root, (String)encoding);
        return requestMessage;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = ZZB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (!"000000".equals(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"QueryTransferImpl_9", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element list = body.getChild("List");
        List lists = list.getChildren("Map");
        if (lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryTransferImpl_1", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            for (Element element : lists) {
                String amount = element.getChildText("Amount");
                if (StringUtils.isEmpty((String)amount)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"QueryTransferImpl_2", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                }
                String accNo = element.getChildText("AcNo");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)accNo, (BigDecimal)new BigDecimal(amount));
                if (paymentInfo == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6839\u636e\u8fd4\u56de\u62a5\u6587\u7684\u6536\u6b3e\u5e10\u53f7\u548c\u91d1\u989d\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u4ed8\u6b3e\u8bb0\u5f55\u3002", (String)"QueryTransferImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                }
                String returnCode = JDomUtils.getChildText((Element)element, (String)"ProcessState");
                logger.info("\u8fd4\u56de\u7801\u4e3a\uff1a" + returnCode + "--" + bankStatus);
                if ("OK".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryTransferImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryTransferImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("FL".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryTransferImpl_5", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                    continue;
                }
                if ("UC".equals(returnCode) || "BH".equalsIgnoreCase(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryTransferImpl_6", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryTransferImpl_7", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return TRANCODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5212\u4e0b\u62e8\u540c\u6b65\u63a5\u53e3", (String)"QueryTransferImpl_8", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/B2EFundcollectRecordDetailQry.do?";
        s = s + "userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=0&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
    }
}

