/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hlbrcb.cmp.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailFileProxy
extends AbstractImpl {
    public String getContent(String fileName) {
        try {
            String rqstStr = this.pack(fileName);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            return this.parse(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private String pack(String fileName) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = this.createHead("fetchFile");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    private String parse(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = this.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 [%1$s\uff0c%2$s]\u3002", (String)"DetailFileProxy_3", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"DetailFileProxy_1", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 [%1$s\uff0c%2$s]\u3002", (String)"DetailFileProxy_3", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        String fileContent = JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
        return fileContent;
    }

    public Element createHead(String bizType) {
        return this.createHead(bizType, Sequence.genSequence());
    }

    public Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"DetailFileProxy_2", (String)"ebg-aqap-banks-hlbrcb-cmp", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public String sendAndRecvMsg(String rqstStr) {
        String rspStr = "";
        try {
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection connection = this.getFrontProxyConnection(factory);
            this.openConnection(connection);
            try (OutputStream os = this.getOutputStream(connection);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(connection);){
                    rspStr = this.recv(is);
                    this.closeOutputStreamQuietly(os);
                    this.closeInputStreamQuietly(is);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rspStr;
    }
}

