/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.idn;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem BNPPID_H2H_PAY_COMPANY_ACNT = PropertyConfigItem.builder().key("BNPPID_H2H_PAY_COMPANY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_0", "ebg-aqap-banks-bnpp-idn")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_0", "ebg-aqap-banks-bnpp-idn")})).isAccNo(true).build();
    private static final PropertyConfigItem BNPPID_H2H_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("BNPPID_H2H_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_1", "ebg-aqap-banks-bnpp-idn")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_2", "ebg-aqap-banks-bnpp-idn")})).build();

    public boolean isForeignBank() {
        return true;
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List configItems = this.getBankAddtionalPropertyConfigItems(false, false, false);
        configItems.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{BNPPID_H2H_PAY_COMPANY_ACNT, BNPPID_H2H_PAY_STATE_TIMEOUT, BANK_SWIFT_CODE}));
        return configItems;
    }

    public static String getPayCompanyName(String accNo) {
        return BNPPID_H2H_PAY_COMPANY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getBicCode(String accNo) {
        return BANK_SWIFT_CODE.getCurrentValueWithObjectID(accNo);
    }

    public static int getPayStateTimeout() {
        String timeOut = BNPPID_H2H_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != timeOut && timeOut.length() > 0) {
            try {
                if (Integer.parseInt(timeOut) > 0) {
                    timeout = Integer.parseInt(timeOut);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime deadlineTime = submitSuccessTime.plus(payStateTimeout, ChronoUnit.HOURS);
        return deadlineTime.isBefore(LocalDateTime.now());
    }
}

