/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.cmp.services.payment;

import java.time.LocalDateTime;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.PackHelper;
import kd.ebg.aqap.banks.xmb.cmp.services.helper.ParserHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CommonQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packRequest(bankPayRequest.getPaymentInfoAsArray());
    }

    private String packRequest(PaymentInfo[] paymentInfos) {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element body = JDomUtils.createRoot((String)"body");
        String testTime = RequestContextUtils.getParameter().getBankParameter("testEnvTime");
        JDomUtils.addChild((Element)body, (String)"reqDate", (String)(!StringUtils.isEmpty((String)testTime) ? testTime : LocalDateUtil.formatDate((LocalDateTime)paymentInfo.getSubmitSuccessTime())));
        JDomUtils.addChild((Element)body, (String)"reqSerialNo", (String)paymentInfo.getBankBatchSeqId());
        return PackHelper.getPackMessage("01603020104A0239", Sequence.genSequence(), body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        this.parseQueryPay(bankPayRequest.getPaymentInfoAsArray(), res);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        BankResponse rsp = ParserHelper.buildHeadMessage(rspStr);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u652f\u4ed8\u7ed3\u679c\u5931\u8d25\u3002", (String)"CommonQueryPayImpl_0", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ParserHelper.getBodyMessage(rspStr);
            String jnlStat = body.getChildText("jnlStat");
            String busiStat = body.getChildText("busiStat");
            String jnlMsg = body.getChildText("jnlMsg");
            if ("S".equals(jnlStat) && "S".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CommonQueryPayImpl_1", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else if ("F".equals(jnlStat) && "F".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CommonQueryPayImpl_2", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else if ("P".equals(jnlStat) && "P".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"CommonQueryPayImpl_3", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else if ("A".equals(jnlStat) && "A".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5df2\u63a5\u6536", (String)"CommonQueryPayImpl_4", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else if ("U".equals(jnlStat) && "U".equals(busiStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"CommonQueryPayImpl_5", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else if ("N".equals(jnlStat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u8be5\u7b14\u6d41\u6c34\u3002", (String)"CommonQueryPayImpl_6", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"CommonQueryPayImpl_5", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]), (String)jnlStat, (String)jnlMsg);
            }
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "01603020104A0239";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u67e5\u8bc1", (String)"CommonQueryPayImpl_7", (String)"ebg-aqap-banks-xmb-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

