/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.RequestPacker;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return this.packNormalTodayBalance(bankBalanceRequest);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String res) {
        return this.parseNormalTodayBalance(bankBalanceRequest, res);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]);
    }

    public String packNormalTodayBalance(BankBalanceRequest request) throws EBServiceException {
        Element head = RequestPacker.getHeadPackerData("200108", "0", Sequence.genSequence());
        Element body = RequestPacker.getBalanceRequestBody(request);
        String requestStr = RequestPacker.getRequest(head, body);
        return requestStr;
    }

    public EBBankBalanceResponse parseNormalTodayBalance(BankBalanceRequest request, String response) throws EBServiceException {
        Element element = CommonUtil.getResponseElement(response);
        CommonUtil.resSuccessCheck(element);
        Element body = element.getChild("body");
        if (!body.getChildText("acno").equalsIgnoreCase(request.getAcnt().getAccNo())) {
            logger.error("\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u6c42\u67e5\u8be2\u7684\u8d26\u6237\u53f7\u3010" + request.getAcnt().getAccNo() + "\u3011\u4e0e\u8fd4\u56de\u7684\u8d26\u6237\u53f7\u3010" + body.getChildText("acno") + "\u3011\u4e0d\u4e00\u81f4");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u8d26\u6237\u53f7\u548c\u8fd4\u56de\u7684\u8d26\u6237\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
        }
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        String balance = body.getChildText("balance");
        String useBalance = body.getChildText("use_balance");
        String curCode = body.getChildText("cur_code");
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
        balanceInfo.setAvailableBalance(BigDecimalHelper.str2BigDecimalForBalance((String)useBalance, (Boolean)true));
        balanceInfo.setBankCurrency(StringUtils.isEmpty((String)curCode) ? request.getBankCurrency() : curCode);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        BankAcnt bankAcnt = new BankAcnt();
        String accNo = request.getAcnt().getAccNo();
        bankAcnt.setAccNo(accNo);
        balanceInfo.setBankAcnt(bankAcnt);
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>();
        balanceInfos.add(balanceInfo);
        balanceRsp.setBalances(balanceInfos);
        return balanceRsp;
    }
}

