/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CommonUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CommonUtil.class);

    public static String createCommonMsg(String xml) throws EBServiceException {
        int digital = 10;
        String msgBody = "00" + xml;
        int msgBodyLen = CommonUtil.getLength(msgBody);
        String msgHead = CommonUtil.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        }
        catch (Exception var4) {
            logger.error("\u83b7\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u51fa\u9519\uff1a" + str + ", encoding:" + encoding, (Throwable)var4);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
        }
        catch (Exception var4) {
            logger.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)var4);
            return "";
        }
    }

    public static Element getResponseElement(String response) {
        String resData = CommonUtil.parseRecvMsg(response);
        if (StringUtils.isEmpty((String)resData)) {
            logger.error("=======\u8fd4\u56de\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a=======");
            throw new EBServiceException(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"CommonUtil_0", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element element = JDomUtils.string2Root((String)resData, (String)encoding);
        return element;
    }

    public static String parseRecvMsg(String input) {
        return !StringUtils.isEmpty((String)input) ? input.substring(12) : "";
    }

    public static BankResponse parseBankResponse(Element head) {
        BankResponse response = new BankResponse();
        String succFlag = head.getChildTextTrim("succ_flag");
        String retCode = head.getChildTextTrim("ret_code");
        String retInfo = head.getChildTextTrim("ret_info");
        String extInfo = head.getChildTextTrim("ext_info");
        String responseMessage = retInfo;
        if (!StringUtils.isEmpty((String)extInfo)) {
            responseMessage = responseMessage + "_" + extInfo;
        }
        response.setResponseCode(succFlag + "_" + retCode);
        response.setResponseMessage(responseMessage);
        return response;
    }

    public static void resSuccessCheck(Element element) {
        Element head = element.getChild("head");
        BankResponse bankResponse = CommonUtil.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            logger.error("\u54cd\u5e94\u5931\u8d25====retCode\uff1a" + bankResponse.getResponseCode() + "===\u5f02\u5e38\u4fe1\u606f:" + bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        logger.info("\u54cd\u5e94\u6210\u529f====retCode\uff1a" + bankResponse.getResponseCode() + "===\u8fd4\u56de\u4fe1\u606f:" + bankResponse.getResponseMessage());
    }
}

