/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.salary.newimpl;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.PaymentUtils;
import kd.ebg.aqap.banks.citic.dc.services.payment.salary.newimpl.SalaryQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 9999;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLUPRSUB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)("" + paymentInfos.size()));
        Element totalAmountElement = JDomUtils.addChild((Element)root, (String)"totalAmount", (String)"");
        JDomUtils.addChild((Element)root, (String)"payAccountNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        if (BankBusinessConfig.isAddKDFlagToPay() && ((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
            JDomUtils.addChild((Element)root, (String)"abstract", (String)PaymentUtils.getFixedExplanation(BizNoUtil.cont((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId(), (String)"\u2605", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation()), 60));
            PaymentUtil.setKdFlagIDByBankBatchSeqID((List)paymentInfos);
        } else {
            JDomUtils.addChild((Element)root, (String)"abstract", (String)PaymentUtils.getFixedExplanation(((PaymentInfo)paymentInfos.get(0)).getExplanation(), 60));
        }
        JDomUtils.addChild((Element)root, (String)"refundFlag", (String)(((PaymentInfo)paymentInfos.get(0)).getMerge() != false ? "N" : "Y"));
        JDomUtils.addChild((Element)root, (String)"preparType", (String)(((PaymentInfo)paymentInfos.get(0)).getMerge() != false ? "1" : "0"));
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"ID", (String)String.format("%05d", i + 1));
            JDomUtils.addChild((Element)row, (String)"recAccountNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"recBankCode", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            JDomUtils.addChild((Element)row, (String)"tranAmount", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            if (BankBusinessConfig.isAddKDFlagToPay() && !((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
                JDomUtils.addChild((Element)row, (String)"abstract", (String)PaymentUtils.getFixedExplanation(BizNoUtil.cont((String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqID(), (String)"\u2605", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 50));
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            } else {
                JDomUtils.addChild((Element)row, (String)"abstract", (String)PaymentUtils.getFixedExplanation(((PaymentInfo)paymentInfos.get(i)).getExplanation(), 50));
            }
            JDomUtils.addChild((Element)row, (String)"field1", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId());
        }
        totalAmountElement.setText(totalAmt.toString());
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        PayParserProxy.parseBatchPay(bankPayRequest.getPaymentInfos(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "DLUPRSUB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e(\u94f6\u8054\u5bf9\u79c1\u4ed8\u6b3e\u7ecf\u529e\u63a5\u53e3DLUPRSUB)\u3002", (String)"SalaryImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

