/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.utils.JsonUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgPacker;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgParser;
import kd.ebg.aqap.banks.cmb.hk.services.utils.PostUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailImpl.class);
    private static final int PAGE_SIZE = 100;

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        JSONArray hkhistransx = new JSONArray();
        JSONObject hkhistransx1 = new JSONObject();
        hkhistransx.add((Object)hkhistransx1);
        hkhistransx1.put("accNum", (Object)accNo);
        hkhistransx1.put("pageSize", (Object)100);
        String currentPage = this.getCurrentPage();
        if ("0".equalsIgnoreCase(currentPage)) {
            this.setCurrentPage("1");
        }
        hkhistransx1.put("pageNum", (Object)this.getCurrentPage());
        hkhistransx1.put("startDate", (Object)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyy-MM-dd"));
        hkhistransx1.put("endDate", (Object)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyy-MM-dd"));
        JSONObject body = new JSONObject();
        body.put("hkhistransx", (Object)hkhistransx);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject requestJson = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(requestJson, this.getBizCode());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        String currentPage;
        int i;
        this.setLastPage(true);
        String res = MsgParser.getReceMsg(rspStr);
        MsgParser.checkResponse(res);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject resp = response.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject result = body.getJSONObject("result");
        if (result == null || result.size() == 0) {
            return new EBBankDetailResponse(detailInfos);
        }
        String total = result.getString("total");
        JSONArray dataList = result.getJSONArray("dataList");
        if (dataList.size() >= 100 && 100 * (i = Integer.parseInt(currentPage = this.getCurrentPage())) < Integer.parseInt(total)) {
            this.setLastPage(false);
        }
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            try {
                JSONObject jsonObject = dataList.getJSONObject(i2);
                DetailInfo detailInfo = new DetailInfo();
                String accNo = jsonObject.getString("accNbr");
                String bankCurrency = jsonObject.getString("ccyNbr");
                String trxAmt = jsonObject.getString("trxAmt");
                String explanation = jsonObject.getString("narrative");
                String tranDate = jsonObject.getString("trxDte");
                String serialNo = jsonObject.getString("ourRef");
                String oppBankName = jsonObject.getString("benClt");
                String oppBankAccount = jsonObject.getString(" benAct");
                String gpiStatus = jsonObject.getString("gpiStatus");
                if ("RJCT".equalsIgnoreCase(gpiStatus) || "RETN".equalsIgnoreCase(gpiStatus)) {
                    detailInfo.setTransType("refund");
                }
                detailInfo.setJsonMap(jsonObject.toJSONString());
                detailInfo.setAccNo(accNo);
                detailInfo.setCurrency(bankCurrency);
                detailInfo.setBankDetailNo(serialNo);
                LocalDate localDate = LocalDateUtil.parserDate((String)tranDate);
                detailInfo.setTransDate(localDate);
                detailInfo.setTransTime(localDate.atTime(LocalTime.MIN));
                detailInfo.setExplanation(explanation);
                detailInfo.setOppAccNo(oppBankAccount);
                detailInfo.setOppAccName(oppBankName);
                if (StringUtils.isEmpty((String)trxAmt)) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailAmountEmptyErrorTips());
                }
                BigDecimal transAmount = new BigDecimal(trxAmt = trxAmt.replace(",", ""));
                if (transAmount.compareTo(BigDecimal.ZERO) < 0) {
                    detailInfo.setDebitAmount(transAmount.abs());
                    detailInfo.setCreditAmount(BigDecimal.ZERO);
                } else {
                    detailInfo.setDebitAmount(BigDecimal.ZERO);
                    detailInfo.setCreditAmount(transAmount.abs());
                }
                detailInfos.add(detailInfo);
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "hkhistrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2", (String)"HisDetailImpl_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        EBBankDetailResponse response;
        this.setLastPage(true);
        this.setCurrentPage(1);
        do {
            try {
                String rqstStr = this.pack(request);
                String rspStr = PostUtil.sendMsg(rqstStr);
                response = this.parse(request, rspStr);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        } while (!this.isLastPage());
        return response;
    }
}

