/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.payment;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.payment.QueryTransType;
import kd.ebg.aqap.banks.cmb.hk.services.utils.BankPayStatusEnum;
import kd.ebg.aqap.banks.cmb.hk.services.utils.JsonUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgPacker;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgParser;
import kd.ebg.aqap.banks.cmb.hk.services.utils.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject hkbizdetailx = new JSONObject();
        String transType = paymentInfo.getBiz("transType");
        if (StringUtils.isEmpty((String)transType)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"transType\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]));
        }
        hkbizdetailx.put("transCode", (Object)transType);
        hkbizdetailx.put("serNo", (Object)paymentInfo.getBankRefID());
        JSONObject body = new JSONObject();
        body.put("hkbizdetailx", (Object)hkbizdetailx);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject requestJson = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(requestJson, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String res = MsgParser.getReceMsg(rspStr);
        MsgParser.checkResponse(res);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject resp = response.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject result = body.getJSONObject("result");
        String transStatus = result.getString("transStatus");
        String failReason = result.getString("failReason");
        if ("FIN".equalsIgnoreCase(transStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)transStatus, (String)BankPayStatusEnum.getDescriptionByValue(transStatus));
        } else if ("ERR".equalsIgnoreCase(transStatus) || "DUE".equalsIgnoreCase(transStatus) || "CEL".equalsIgnoreCase(transStatus) || "REJ".equalsIgnoreCase(transStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)transStatus, (String)(BankPayStatusEnum.getDescriptionByValue(transStatus) + "_" + failReason));
        } else if ("AUT".equalsIgnoreCase(transStatus) || "NTE".equalsIgnoreCase(transStatus) || "BNK".equalsIgnoreCase(transStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)transStatus, (String)BankPayStatusEnum.getDescriptionByValue(transStatus));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)transStatus, (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        try {
            PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
            String transType = paymentInfo.getBiz("transType");
            if (StringUtils.isEmpty((String)transType)) {
                QueryTransType queryTransType = new QueryTransType();
                queryTransType.doBiz(bankPayRequest);
            }
            String rqstStr = this.pack(bankPayRequest);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(bankPayRequest, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "hkbizdetail";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u67e5\u8be2", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]);
    }
}

