/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scb.h2h.service.payment.oversea;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scb.h2h.service.SCBH2H_Packer;
import kd.ebg.aqap.banks.scb.h2h.service.SCBH2H_Parser;
import kd.ebg.aqap.banks.scb.h2h.service.payment.company.QueryPayImpl;
import kd.ebg.aqap.banks.scb.h2h.service.payment.util.ScbUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "OVERSEA_PAY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5883\u5916\u652f\u4ed8", (String)"PayImpl_5", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element simulator = new Element("simulator");
        Element head = SCBH2H_Packer.createHead("OVERSEA_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfos[0].getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[i]);
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"acntNo", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)list, (String)"acntName", (String)paymentInfos[i].getAccName());
            JDomUtils.addChild((Element)list, (String)"acntType", (String)"");
            JDomUtils.addChild((Element)list, (String)"acntBankName", (String)paymentInfos[i].getBankName());
            JDomUtils.addChild((Element)list, (String)"acntCountry", (String)paymentInfos[i].getAccCountry());
            JDomUtils.addChild((Element)list, (String)"acntProvince", (String)paymentInfos[i].getAccProvince());
            JDomUtils.addChild((Element)list, (String)"acntCity", (String)paymentInfos[i].getAccCity());
            JDomUtils.addChild((Element)list, (String)"acntBankBranchNo", (String)paymentInfos[i].getAreaCode());
            JDomUtils.addChild((Element)list, (String)"acntBankCnapsNo", (String)"");
            JDomUtils.addChild((Element)list, (String)"currency", (String)paymentInfos[i].getCurrency());
            JDomUtils.addChild((Element)list, (String)"startDate", (String)SCBH2H_Packer.formatDate(LocalDate.now()));
            JDomUtils.addChild((Element)list, (String)"startTime", (String)SCBH2H_Packer.formatTime(LocalTime.now()));
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)list, (String)"txAmt", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfos[i].getActualAmount()));
            JDomUtils.addChild((Element)list, (String)"urgentFlag", (String)(paymentInfos[i].is2Urgent() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameBankFlag", (String)(paymentInfos[i].is2SameBank() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"sameCityFlag", (String)(paymentInfos[i].is2SameCity() ? "true" : "false"));
            JDomUtils.addChild((Element)list, (String)"payType", (String)(true == paymentInfos[i].is2Individual() ? "individual" : "company"));
            JDomUtils.addChild((Element)list, (String)"email", (String)paymentInfos[i].getEmails());
            JDomUtils.addChild((Element)list, (String)"oppAcntNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)list, (String)"oppAcntName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)list, (String)"oppAcntNameEN", (String)"");
            JDomUtils.addChild((Element)list, (String)"oppBankName", (String)paymentInfos[i].getIncomeBankName());
            String benefitBankAddress = paymentInfos[i].getIncomeAddress();
            if (StringUtils.isEmpty((String)benefitBankAddress)) {
                benefitBankAddress = paymentInfos[i].getIncomeBankAddress();
            }
            JDomUtils.addChild((Element)list, (String)"benefitBankAddress", (String)benefitBankAddress);
            String country = paymentInfos[i].getIncomeCountry();
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(country);
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"PayImpl_8", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]), country));
            }
            JDomUtils.addChild((Element)list, (String)"oppAcntCountry", (String)code.geteChart2());
            JDomUtils.addChild((Element)list, (String)"beneficiaryType", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[i], (String)"beneficiaryType"));
            JDomUtils.addChild((Element)list, (String)"oppAcntCity", (String)paymentInfos[i].getIncomeCity());
            JDomUtils.addChild((Element)list, (String)"oppBankBranchNo", (String)paymentInfos[i].getIncomeAreaCode());
            if (PropertiesConstants.getValue((String)"CHINA").equalsIgnoreCase(paymentInfos[i].getAccCountry()) && "CNY".equalsIgnoreCase(paymentInfos[i].getCurrency())) {
                JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)paymentInfos[i].getIncomeCnaps());
            } else {
                JDomUtils.addChild((Element)list, (String)"oppBankCnapsNo", (String)paymentInfos[i].getIncomeSwiftCode());
            }
            JDomUtils.addChild((Element)list, (String)"useCode", (String)"");
            String explanation = paymentInfos[i].getExplanation();
            if (!StringUtils.isEmpty((String)explanation) && explanation.length() > 30) {
                explanation = explanation.substring(0, 30);
            }
            JDomUtils.addChild((Element)list, (String)"explanation", (String)explanation);
            JDomUtils.addChild((Element)list, (String)"incomeBankLocalClearingCode", (String)paymentInfos[i].getIncomeBankLocalClearingCode());
            JDomUtils.addChild((Element)list, (String)"incomeBankLocalClearingBranchCode", (String)paymentInfos[i].getIncomeBankLocalClearingBranchCode());
            JDomUtils.addChild((Element)list, (String)"incomeBankLocalClearingBranchsubCode", (String)paymentInfos[i].getIncomeBankLocalClearingBranchSubCode());
            JDomUtils.addChild((Element)list, (String)"paymentMethod", (String)paymentInfos[i].getUseCn());
            String transactionRemarks = paymentInfos[i].getTransactionRemarks();
            JDomUtils.addChild((Element)list, (String)"transactionRemarks", (String)transactionRemarks);
            JDomUtils.addChild((Element)list, (String)"payPurpose", (String)ScbUtils.getPodCodeByExplanation(explanation));
            if (!SCBH2H_Packer.isContainsStrangeStr(paymentInfos[i].getIncomeAccNo())) continue;
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7\uff0c\u4e0d\u80fd\u542b\u6709\u975e\u6cd5\u5b57\u7b26\uff1a ~ ! @ # $ % ^ & * _ { } \" ` = [ ] ;", (String)"PayImpl_1", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]));
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = SCBH2H_Parser.parseHeader(root);
        if ("BIZ_FAIL".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String sequence = JDomUtils.getChildTextTrim((Element)list, (String)"sequence");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)sequence);
            if (null == info) continue;
            if ("BCC_PAY_SUBMT_SUCCESS".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

