/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchDepositBalBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(DepositBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        List bankAcntList = bankBalanceRequest.getBankAcntList();
        bankAcntList = bankAcntList.stream().filter(bankAcnt -> BankBusinessConfig.isQueryDepositBal(bankAcnt.getAccNo())).collect(Collectors.toList());
        Element root = BOCOM_DC_Packer.packRoot("310105", bankAcntList.size());
        for (BankAcnt bankAcnt2 : bankAcntList) {
            Element body = JDomUtils.addChild((Element)root, (String)"body");
            String accNo = bankAcnt2.getAccNo();
            JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        ParserUtils.checkRspCode((BankResponse)rsp, (String)"0000");
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"field_num");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"record_num");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serial_record");
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = serial_record.split("\\|");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(10);
        for (int i = 1; i <= recordNum; ++i) {
            String accNo = splits[fieldNum * i];
            String balance = splits[fieldNum * i + 2];
            String rspMsg = splits[fieldNum * i + 5];
            String rspCode = splits[fieldNum * i + 6];
            if (!"0".equals(rspCode)) {
                this.log.info("\u8d26\u6237" + accNo + "\u67e5\u8be2\u5931\u8d25,\u539f\u56e0" + rspMsg);
                continue;
            }
            BalanceInfo balanceInfo = new BalanceInfo();
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            balanceInfo.setBankAcnt(bankAcnt);
            balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            this.setDepositBalance(balanceInfo, balance);
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "310105";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2", (String)"DepositBalanceImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        List bankAcntList = request.getBankAcntList();
        if (bankAcntList == null) {
            return false;
        }
        boolean matchConfig = bankAcntList.stream().filter(bankAcnt -> BankBusinessConfig.isQueryDepositBal(bankAcnt.getAccNo())).collect(Collectors.toList()).isEmpty();
        return matchTime && !matchConfig;
    }
}

