/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.detail;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.detail.DetailParser;
import kd.ebg.aqap.banks.bocom.dc.service.detail.OsaDetailHelper;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail {
    public String pack(BankDetailRequest request) {
        Element root;
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        if (BankBusinessConfig.isSecondaryAccount(accNo)) {
            root = BOCOM_DC_Packer.packRoot("585047");
            Element body = JDomUtils.addChild((Element)root, (String)"body");
            JDomUtils.addChild((Element)body, (String)"man-acno", (String)BankBusinessConfig.getUpAccount(accNo));
            JDomUtils.addChild((Element)body, (String)"mbr-acno", (String)accNo);
            JDomUtils.addChild((Element)body, (String)"start_date", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
            JDomUtils.addChild((Element)body, (String)"end_date", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        } else {
            if (BankBusinessConfig.isOsaAcnt(accNo)) {
                return OsaDetailHelper.packTodayDetail(request);
            }
            root = BOCOM_DC_Packer.packRoot("310201");
            Element body = JDomUtils.addChild((Element)root, (String)"body");
            JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
            RequestContextUtils.setRunningParam((String)"interface_name", (String)"310201");
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<DetailInfo> detailInfos = BankBusinessConfig.isOsaAcnt(request.getAcnt().getAccNo()) ? OsaDetailHelper.parseDetail(request, responseStr) : DetailParser.parseTodayDetail(request, responseStr);
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "310201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u660e\u7ec6", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        if (Utils.isHKBiz(request.getAcnt().getAccNo())) {
            return false;
        }
        return "normalDetail".equals(BankBusinessConfig.getDetailInterfaceChoose());
    }
}

