/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.hk.pay;

import com.google.common.collect.Lists;
import java.util.List;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.business.bankstatus.IBankStatus;
import kd.ebg.aqap.business.bankstatus.Status;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I440103
extends AbstractQueryPayImpl
implements IQueryPay {
    public static final I440103Status i440103Status = new I440103Status();

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = Utils.createBody(root);
        JDomUtils.addChild((Element)body, (String)"transSeqType", (String)"2");
        JDomUtils.addChild((Element)body, (String)"transSeqNo", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"bankFlag", (String)Utils.getBankFlagForInquiryPay(BankBusinessConfig.getCountryAreaAccount(paymentInfo.getAccNo())));
        return Utils.intoString(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            Element body = root.getChild("body");
            String transRes = body.getChildTextTrim("transRes");
            String error = body.getChildTextTrim("error");
            Status status = i440103Status.get(transRes);
            if (status != null) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)status.getEbgState(), (String)"", (String)transRes, (String)error);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)transRes, (String)error);
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "440103";
    }

    public String getBizDesc() {
        return "";
    }

    public static class I440103Status
    implements IBankStatus {
        public List<Status> getStatusList() {
            return Lists.newArrayList((Object[])new Status[]{Status.newStatus((String)"00", (String)"", (PaymentState)PaymentState.SUCCESS), Status.newStatus((String)"07", (String)"", (PaymentState)PaymentState.SUCCESS), Status.newStatus((String)"01", (String)"", (PaymentState)PaymentState.FAIL), Status.newStatus((String)"08", (String)"", (PaymentState)PaymentState.FAIL), Status.newStatus((String)"09", (String)"", (PaymentState)PaymentState.FAIL), Status.newStatus((String)"10", (String)"", (PaymentState)PaymentState.FAIL), Status.newStatus((String)"11", (String)"", (PaymentState)PaymentState.FAIL), Status.newStatus((String)"12", (String)"", (PaymentState)PaymentState.UNKNOWN)});
        }
    }
}

