/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.hk.statement;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.hk.Utils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class I430103
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(I430103.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = Utils.createBody(root);
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"area", (String)BankBusinessConfig.getCountryAreaAccount(accNo));
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String offset = "";
        if (!"0".equalsIgnoreCase(this.getCurrentPage())) {
            offset = this.getCurrentPage();
        }
        JDomUtils.addChild((Element)body, (String)"offset", (String)offset);
        return Utils.intoString(root);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        Element body = Utils.getBody(s);
        String serialRecord = body.getChildTextTrim("serial_record");
        String field_num = body.getChildTextTrim("field_num");
        String record_num = body.getChildTextTrim("record_num");
        if (StringUtils.isEmpty((String)field_num)) {
            field_num = "0";
        }
        if (StringUtils.isEmpty((String)record_num)) {
            record_num = "0";
        }
        int fieldNum = Integer.parseInt(field_num);
        int recordNum = Integer.parseInt(record_num);
        String[] splits = StringUtils.split((String)serialRecord, (String)"|");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (int i = 1; i <= recordNum; ++i) {
            try {
                String currency = splits[fieldNum * i + 10];
                String drcrf = splits[fieldNum * i + 11];
                DetailInfo detail = new DetailInfo();
                detail.setCurrency(currency);
                detail.setAccNo(splits[fieldNum * i]);
                detail.setAccName(bankDetailRequest.getAcnt().getAccName());
                BigDecimal amount = new BigDecimal(splits[fieldNum * i + 12]);
                if ("D".equalsIgnoreCase(drcrf)) {
                    detail.setDebitAmount(amount);
                    detail.setCreditAmount(ParserUtils.ZERO);
                } else {
                    if (!"C".equalsIgnoreCase(drcrf)) continue;
                    detail.setDebitAmount(ParserUtils.ZERO);
                    detail.setCreditAmount(amount);
                }
                detail.setOppAccNo(splits[fieldNum * i + 15]);
                detail.setOppAccName(splits[fieldNum * i + 16]);
                detail.setOppBankName(splits[fieldNum * i + 20]);
                detail.setExplanation(splits[fieldNum * i + 19]);
                JSONObject receiptJson = new JSONObject();
                String detailSequence = splits[fieldNum * i + 8];
                String logNo = splits[fieldNum * i + 9];
                receiptJson.put("transDate", (Object)splits[fieldNum * i + 6]);
                receiptJson.put("serialNo", (Object)(detailSequence + "@" + logNo));
                receiptJson.put("logNo", (Object)logNo);
                receiptJson.put("detailSequence", (Object)detailSequence);
                receiptJson.put("Amount", (Object)splits[fieldNum * i + 12]);
                receiptJson.put("remark", (Object)detail.getExplanation());
                receiptJson.put("cdFlag", (Object)drcrf);
                detail.setJsonMap(receiptJson.toJSONString());
                detail.setBankDetailNo(detailSequence);
                LocalDateTime transDateTime = LocalDateTime.parse(splits[fieldNum * i + 6] + splits[fieldNum * i + 7], DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransDate(transDateTime.toLocalDate());
                detail.setTransTime(transDateTime);
                if (!StringUtils.isEmpty((String)splits[fieldNum * i + 13])) {
                    detail.setBalance(new BigDecimal(splits[fieldNum * i + 13].trim()));
                }
                detailList.add(detail);
                continue;
            }
            catch (Exception e) {
                logger.error(String.format("\u89e3\u6790\u7b2c%s\u660e\u7ec6\u6570\u636e\u5f02\u5e38", i), (Throwable)e);
            }
        }
        String endflag = body.getChildTextTrim("endflag");
        if ("N".equalsIgnoreCase(endflag)) {
            this.setLastPage(false);
            String offset = body.getChildTextTrim("offset");
            this.setCurrentPage(offset);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "430103";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isSupportPage() {
        return true;
    }

    public boolean match(BankDetailRequest request) {
        return Utils.isHKBiz(request.getAcnt().getAccNo());
    }
}

