/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.individual.otherbank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 500;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "210230";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = BOCOM_DC_Packer.packRoot("210230");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"dealNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentsWithoutStauts((List)paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002 ", (String)"BatchQueryPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        String field_num = ParserUtils.checkUnNullableElement((Element)body, (String)"fieldNum");
        String record_num = ParserUtils.checkUnNullableElement((Element)body, (String)"recordNum");
        String serial_record = ParserUtils.checkUnNullableElement((Element)body, (String)"serialRecord");
        String batStt = ParserUtils.checkUnNullableElement((Element)body, (String)"batStt");
        int recordNum = Integer.parseInt(record_num);
        if (0 == recordNum) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u652f\u4ed8\u7ed3\u679c\u5931\u8d25 \uff1a310207\u4ea4\u6613\u8fd4\u56de\u8bb0\u5f55\u6570\u4e3a0\u6761\uff0c\u65e0\u6cd5\u786e\u8ba4\u5f53\u524d\u4ea4\u6613\u72b6\u6001\u3002", (String)"BatchQueryPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        if (!("7".equalsIgnoreCase(batStt) || "8".equalsIgnoreCase(batStt) || "22".equalsIgnoreCase(batStt))) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchQueryPayImpl_4", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
            return new EBBankPayResponse(paymentInfos);
        }
        List paymentInfoAll = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfoAll);
        paymentInfos = request.getPaymentInfos();
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = StringUtils.split((String)serial_record, (String)"|");
        for (int i = 1; i <= recordNum; ++i) {
            String payAmount = splits[fieldNum * i + 2];
            String inAcntNo = splits[fieldNum * i + 0];
            String stat = splits[fieldNum * i + 3];
            String errorMessage = splits[fieldNum * i + 4];
            if (StringUtils.isEmpty((String)payAmount)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u901a\u94f6\u884c\u4ee3\u53d1\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\uff0c\u8fd4\u56de\u7684\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"BatchQueryPayImpl_3", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
            }
            BigDecimal amount = new BigDecimal(payAmount.trim());
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)inAcntNo, (BigDecimal)amount);
            if (null == paymentInfo) continue;
            this.handlePayStatus(paymentInfo, stat, errorMessage);
        }
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        this.processingBankItemDataHandler(splits, paymentInfos, fieldNum, recordNum);
        PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos, (boolean)false, (boolean)false);
        return new EBBankPayResponse(paymentInfos);
    }

    private void processingBankItemDataHandler(String[] splits, List<PaymentInfo> paymentInfos, int fieldNum, int recordNum) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 1; i <= recordNum; ++i) {
                    String bankDataKey;
                    String payAmount = splits[fieldNum * i + 2];
                    String inAcntNo = splits[fieldNum * i + 0];
                    String stat = splits[fieldNum * i + 3];
                    String errorMessage = splits[fieldNum * i + 4];
                    BigDecimal amount = new BigDecimal(payAmount.trim());
                    PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)inAcntNo, (BigDecimal)amount);
                    if (paymentInfo == null || !HashSetKeys.contains(bankDataKey = PayStatusMatchUtil.getKeyByPaymentInfo((PaymentInfo)paymentInfo, (boolean)false, (boolean)false))) continue;
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, stat, errorMessage);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private void handlePayStatus(PaymentInfo paymentInfo, String stat, String errorMessage) {
        if ("3".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)stat, (String)"");
        } else if ("4".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)stat, (String)errorMessage);
        } else if ("1".equalsIgnoreCase(stat)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)stat, (String)errorMessage);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)stat, (String)errorMessage);
        }
    }
}

