/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.income.IncomePayImpl;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.inner.CompanyPayImpl;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = this.getBusiImplInfo(paymentInfo);
        paymentInfo.setImplClassName(busiImplInfo.getImplName());
        paymentInfo.setQueryImplClassName(busiImplInfo.getQueryImplName());
        paymentInfo.setPackageKey(busiImplInfo.getPackageKey());
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("accNo=").append(paymentInfo.getAccNo());
        packageKey.append(';');
        packageKey.append("sameBank=").append(paymentInfo.is2SameBank());
        packageKey.append(';');
        packageKey.append("urgent=").append(paymentInfo.is2Urgent());
        packageKey.append(';');
        String subBizType = paymentInfo.getSubBizType();
        if ("income".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u5b9e\u73b0income\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]));
        }
        if ("pay_for_salary".equals(subBizType)) {
            busiImplInfo.setImplName(SalaryPayImpl.class.getName());
        } else if ("pay_for_capital_allocation".equals(subBizType)) {
            this.setCapitalAllocationImpl(paymentInfo, busiImplInfo);
        } else if ("pay".equals(subBizType)) {
            this.setPayImpl(paymentInfo, busiImplInfo);
        } else if (!"pay_for_linkpay".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s\u3002", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), subBizType));
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    private void setCapitalAllocationImpl(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        if ("Company".equals(BankBusinessConfig.getAllocationType())) {
            this.setPayImpl(paymentInfo, busiImplInfo);
        } else {
            busiImplInfo.setImplName(IncomePayImpl.class.getName());
        }
    }

    private void setPayImpl(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        if (paymentInfo.is2SameBank()) {
            busiImplInfo.setImplName(CompanyPayImpl.class.getName());
        } else {
            busiImplInfo.setImplName(kd.ebg.aqap.banks.gzrcb.dc.service.payment.outer.CompanyPayImpl.class.getName());
        }
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Pretreatment";
    }

    public String getBizDesc() {
        return "Pretreatment";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

