/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.service.Constants;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.GzrcbFileDownloadImpl;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.ParserUtil;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    public EBBankPayResponse parseQueryPay(PaymentInfo[] infos, String rsp, String bizSeqId) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        Element header = JDomUtils.getChildElement((Element)root, (String)"comm_head");
        BankResponseResult result = ParserUtil.paserHeadResponse(header);
        if (result.isSuccess()) {
            Element body = JDomUtils.getChildElement((Element)root, (String)"main_data");
            String batchState = JDomUtils.getChildText((Element)body, (String)"BATSTA");
            String msg = JDomUtils.getChildText((Element)body, (String)"CUOWXX");
            if ("00".equals(batchState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8fd8\u672a\u5904\u7406\u3002", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8fd8\u672a\u5904\u7406\u3002", (String)"QueryPayParser_4", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)msg);
            } else if ("01".equals(batchState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5904\u7406\u4e2d\u3002", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5904\u7406\u4e2d\u3002", (String)"QueryPayParser_5", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)msg);
            } else if ("99".equals(batchState)) {
                String successCount = JDomUtils.getChildText((Element)body, (String)"CGJYBS");
                String failedCountStr = JDomUtils.getChildText((Element)body, (String)"SBJYBS");
                int count = 0;
                int failedCount = 0;
                if (!StringUtils.isEmpty((String)successCount)) {
                    count = Integer.parseInt(successCount);
                }
                if (!StringUtils.isEmpty((String)failedCountStr)) {
                    failedCount = Integer.parseInt(failedCountStr);
                }
                if (count == infos.length) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u91cf\u5904\u7406\u6210\u529f\u3002", (String)"QueryPayParser_6", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)msg);
                } else if (failedCount == infos.length) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u91cf\u5904\u7406\u5931\u8d25\u3002", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)msg);
                } else {
                    String fileName = JDomUtils.getChildText((Element)body, (String)"FILENM");
                    if (!StringUtils.isEmpty((String)fileName)) {
                        GzrcbFileDownloadImpl util = new GzrcbFileDownloadImpl();
                        String content = util.downloadFile(fileName);
                        Map<String, BankResponseResult> resultMap = this.getResponseFromFile(content);
                        for (PaymentInfo info : infos) {
                            BankResponseResult responseResult = resultMap.get(info.getBankDetailSeqId());
                            if (Objects.isNull(responseResult)) continue;
                            if (responseResult.isSuccess()) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5904\u7406\u6210\u529f", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)responseResult.getResponseCode(), (String)(StringUtils.isEmpty((String)responseResult.getBankMessage()) ? msg : responseResult.getBankMessage()));
                                continue;
                            }
                            if (!responseResult.isFailed()) continue;
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5904\u7406\u5931\u8d25\u3002", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)responseResult.getResponseCode(), (String)(StringUtils.isEmpty((String)responseResult.getBankMessage()) ? msg : responseResult.getBankMessage()));
                        }
                    }
                }
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), (String)result.getResponseCode(), (String)result.getBankMessage());
        }
        return new EBBankPayResponse(Arrays.asList(infos));
    }

    private Map<String, BankResponseResult> getResponseFromFile(String fileContent) {
        HashMap<String, BankResponseResult> result = new HashMap<String, BankResponseResult>();
        String[] fileLines = StringUtils.split((String)fileContent, (String)"\n");
        int i = 0;
        while (i * 8 < fileLines.length) {
            if (!StringUtils.isEmpty((String)fileLines[i])) {
                String[] fileFragments = StringUtils.split((String)fileLines[i], (String)"|");
                String sequnce = fileFragments[6];
                String stateCode = fileFragments[4];
                String msg = fileFragments[5];
                if (!StringUtils.isEmpty((String)sequnce)) {
                    BankResponseResult responseResult = new BankResponseResult(stateCode, Constants.SALARY_SUCCESS_CODES, Constants.SALARY_FAILED_CODES);
                    responseResult.setBankMessage(msg);
                    result.put(sequnce, responseResult);
                }
            }
            ++i;
        }
        return result;
    }
}

