/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonPacker;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonParser;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.GSNXConstants;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public String pack(BankDetailRequest request) {
        JSONObject body = new JSONObject();
        body.put("acc", (Object)request.getAcnt().getAccNo());
        body.put("acc_name", (Object)request.getAcnt().getAccName());
        body.put("start_date", (Object)LocalDateUtil.formatDate((LocalDate)request.getStartDate()));
        body.put("end_date", (Object)LocalDateUtil.formatDate((LocalDate)request.getEndDate()));
        this.setCurrentPage(this.getCurrentPage());
        body.put("strt_num", (Object)this.getCurrentPage());
        body.put("end_num", (Object)100);
        return CommonPacker.createRootMsg(body, GSNXConstants.DETAIL);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        JSONObject body = CommonParser.getRespBody(res);
        String endFlag = body.getString("end_flag");
        JSONArray respList = body.getJSONArray("resp_list");
        if (respList == null || respList.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        if ("1".equals(endFlag)) {
            this.setLastPage(false);
            String currentPage = this.getCurrentPage();
            int page = Integer.parseInt(currentPage) + 100;
            this.setCurrentPage(page);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String acc = body.getString("acc");
        String acc_name = body.getString("acc_name");
        if (StringUtils.isEmpty((String)acc_name)) {
            acc_name = acnt.getAccName();
        }
        if (StringUtils.isEmpty((String)acc)) {
            acc = acnt.getAccNo();
        }
        if (!acc.equals(acnt.getAccNo())) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u548c\u8bf7\u6c42\u8d26\u6237\u4e0d\u5339\u914d");
            return new EBBankDetailResponse(detailList);
        }
        if (respList.size() < 100) {
            this.setLastPage(true);
        }
        for (Object o : respList) {
            DetailInfo detail = new DetailInfo();
            try {
                JSONObject record = (JSONObject)o;
                String respSerialNo = record.getString("resp_sn");
                String amt = record.getString("amt");
                String cdflg = record.getString("cdflg");
                String balance = record.getString("balance");
                String oppAcc = record.getString("opp_acc");
                String oppAccName = record.getString("opp_acc_name");
                String oppBankName = record.getString("opp_bank_name");
                String transDate = record.getString("trans_data");
                String transTime = record.getString("trans_time");
                String transSerialNo = record.getString("trans_sn");
                String explanation = record.getString("trans_abstr");
                detail.setCurrency(bankDetailRequest.getBankCurrency());
                detail.setOppAccNo(oppAcc);
                detail.setOppAccName(oppAccName);
                detail.setOppBankName(oppBankName);
                detail.setAccName(acc_name);
                detail.setAccNo(acc);
                if (StringUtils.isEmpty((String)transDate)) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailTransDateEmptyErrorTips());
                }
                detail.setTransDate(LocalDateUtil.parserDate((String)transDate));
                detail.setTransTime(LocalDateUtil.parseDateTime((String)(transDate + " " + transTime.substring(0, 6)), (String)"yyyyMMdd HHmmss"));
                if (StringUtils.isEmpty((String)amt)) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailAmountEmptyErrorTips());
                }
                BigDecimal amount = new BigDecimal(amt);
                if ("0".equalsIgnoreCase(cdflg)) {
                    detail.setDebitAmount(amount);
                    detail.setCreditAmount(new BigDecimal(0));
                } else if ("1".equalsIgnoreCase(cdflg)) {
                    detail.setDebitAmount(new BigDecimal(0));
                    detail.setCreditAmount(amount);
                } else {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)cdflg));
                }
                detail.setExplanation(explanation);
                detail.setBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)true));
                detail.setJsonMap(record.toJSONString());
                detail.setId(respSerialNo);
                detail.setBankDetailNo(transSerialNo);
                String receiptNo = MatchRule.getInstance().getReceiptNo(acc, detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), detail.getJsonMap());
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detailList.add(detail);
            }
            catch (Exception e) {
                this.logger.error("\u660e\u7ec6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return GSNXConstants.DETAIL.getEnName();
    }

    public String getBizDesc() {
        return GSNXConstants.DETAIL.getCnName();
    }

    public boolean isSupportPage() {
        return true;
    }
}

