/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.payment;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.List;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonPacker;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonParser;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.GSNXConstants;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject body = new JSONObject();
        body.put("pay_acno", (Object)paymentInfo.getAccNo());
        body.put("pay_acname", (Object)paymentInfo.getAccName());
        body.put("tran_seq", (Object)paymentInfo.getBankDetailSeqId());
        body.put("tran_date", (Object)LocalDateUtil.formatDate((LocalDate)paymentInfo.getSubmitSuccessTime().toLocalDate()));
        return CommonPacker.createRootMsg(body, GSNXConstants.QUERYPAY);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        JSONObject body = CommonParser.getRespBody(res);
        String tranStat = body.getString("stat");
        String msg = body.getString("err_info");
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if ("00".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)tranStat, (String)msg);
        } else if ("03".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)tranStat, (String)msg);
        } else if ("02".equals(tranStat) || "99".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)tranStat, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)tranStat, (String)msg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return GSNXConstants.QUERYPAY.getEnName();
    }

    public String getBizDesc() {
        return GSNXConstants.QUERYPAY.getCnName();
    }
}

