/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.utils;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalTime;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonUtils;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.Constants;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.GSNXConstants;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.SMUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import org.apache.commons.codec.binary.Base64;

public class CommonPacker {
    public static String createRootMsg(JSONObject body, GSNXConstants constant) {
        try {
            JSONObject root = new JSONObject();
            root.put("sys_header", (Object)CommonPacker.createHeader(constant.getEnName(), Sequence.gen16Sequence()));
            root.put("body", (Object)body);
            return CommonPacker.getSendMsg(root.toJSONString());
        }
        catch (EBServiceException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String createRootMsg(JSONObject body, GSNXConstants constant, String seqNO) {
        JSONObject root = new JSONObject();
        root.put("sys_header", (Object)CommonPacker.createHeader(constant.getEnName(), seqNO));
        root.put("body", (Object)body);
        return CommonPacker.getSendMsg(root.toJSONString());
    }

    public static JSONObject createHeader(String transCode, String seqNo) {
        JSONObject header = new JSONObject();
        header.put("std_intf_ind", (Object)transCode);
        header.put("chnl_code", (Object)RequestContextUtils.getBankParameterValue((String)Constants.CHANNEL_NO));
        header.put("cnsmr_txn_dt", (Object)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        header.put("cnsmr_txn_tm", (Object)LocalDateUtil.formatLocalTime((LocalTime)LocalTime.now()));
        header.put("cnsmr_rung_num", (Object)seqNo);
        header.put("busi_no", (Object)RequestContextUtils.getBankParameterValue((String)Constants.BUSINESS_NO));
        return header;
    }

    public static String getSendMsg(String jsonStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(CommonPacker.class);
        logger.info("\u62a5\u6587\u8bf7\u6c42\u52a0\u5bc6\u524d:{}", (Object)jsonStr);
        try {
            String signPrivateKey = CommonUtils.getKeyValue(Constants.SIGN_PRIVATE_KEY);
            String encodePublicKey = CommonUtils.getKeyValue(Constants.ENCODE_PUBLIC_KEY);
            SMUtil smUtil = new SMUtil();
            byte[] signBytes = smUtil.sm2Sign(signPrivateKey, jsonStr);
            String base64Sign = Base64.encodeBase64String((byte[])signBytes);
            byte[] enyptByte = smUtil.sm2Encrypt(encodePublicKey, jsonStr);
            String sm4base64str = Base64.encodeBase64String((byte[])enyptByte);
            JSONObject req = new JSONObject();
            req.put("sign", (Object)base64Sign);
            req.put("data", (Object)sm4base64str);
            req.put("busi_no", (Object)RequestContextUtils.getBankParameterValue((String)Constants.BUSINESS_NO));
            String reqFmt = req.toString();
            return reqFmt;
        }
        catch (EBServiceException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

