/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.utils;

import java.util.concurrent.TimeUnit;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class CommonUtils {
    public static String getKeyValue(String keyId) {
        String key = keyId + "_GSNX_DC_certifyKey";
        String secretKey = CosmicCache.get((String)key);
        if (StringUtils.isEmpty((String)secretKey)) {
            UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
            CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(keyId, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
            AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
            CipherInfo cipherInfo = security.getCipherInfo(certInfo.getFileContent());
            int version = cipherInfo.getCipherVersion();
            byte[] certBytes = Base64.decodeBase64((String)cipherInfo.getCipherData());
            byte[] plainData = DesUtil.decryptProxyCert((byte[])certBytes, (String)RequestContextUtils.getCustomId(), (int)version, (String)"");
            secretKey = StringUtils.byteToString((byte[])plainData);
            CosmicCache.putIfAbsentWithExpire((String)key, (String)secretKey, (int)60, (TimeUnit)TimeUnit.SECONDS);
        }
        return secretKey;
    }
}

