/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.services.payment.pay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjnxs.dc.services.payment.B2EGroupTrsStatusQry;
import kd.ebg.aqap.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class B2EGroupTransfer
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return B2EGroupTrsStatusQry.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)EBUtils.buildPackerHead(this.getBizCode(), info.getBankBatchSeqID()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        String accNo = info.getAccNo();
        String groupAccount = BankBusinessConfig.getGroupAccount(accNo);
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)groupAccount);
        JDomUtils.addChild((Element)Map2, (String)"SubPayerAcNo", (String)accNo);
        JDomUtils.addChild((Element)Map2, (String)"SubPayerAcName", (String)info.getAccName());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)Map2, (String)"PayeeBankName", (String)info.getIncomeBankName());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)info.getAmount().toString());
        String exp = info.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            exp = info.getBankDetailSeqId() + "_KD_" + exp;
        }
        JDomUtils.addChild((Element)Map2, (String)"Remark", (String)exp);
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        BankResponse headRsp = EBUtils.parserResponseInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if ("000000".equals(bankStatus)) {
            Element body = bank_root.getChild("Body");
            Element list = body.getChild("List");
            List lists = list.getChildren("Map");
            Element element = (Element)lists.get(0);
            String tranStatus = JDomUtils.getChildText((Element)element, (String)"TranStatus");
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)tranStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EGroupTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u96c6\u56e2\u666e\u901a\u5bf9\u5916\u652f\u4ed8", (String)"B2EGroupTransfer_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EGroupTransfer.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"cif") + "&SIGDATA=1";
        factory.setUri(s);
    }
}

