/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.balance;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.PackerUtil;
import kd.ebg.aqap.banks.bjb.dc.service.ParserUtil;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginImpl;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LastDayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead("CebankQueryBalanceOp", Sequence.genSequence());
        List acntList = bankBalanceRequest.getBankAcntList();
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        JDomUtils.addChild((Element)param, (String)"accountNo", (String)((BankAcnt)acntList.get(0)).getAccNo());
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, "CebankQueryBalanceOp");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GB18030");
        BankResponse bankResponse = ParserUtil.parserRep(root);
        Preconditions.checkState((boolean)"0".equalsIgnoreCase(bankResponse.getResponseCode()), (Object)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"LastDayBalanceImpl_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        Element opReq = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        Element element = JDomUtils.getChildElementNotNull((Element)opReq, (String)"opResult");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        String balance = JDomUtils.getChildTextNotNull((Element)element, (String)"balance");
        String hisBalance = JDomUtils.getChildTextNotNull((Element)element, (String)"hisBal");
        BankAcnt bankAcnt = (BankAcnt)request.getBankAcntList().get(0);
        balanceInfo.setBankAcnt(bankAcnt);
        balanceInfo.setBankCurrency(JDomUtils.getChildTextNotNull((Element)element, (String)"acctCur"));
        if (StringUtils.isEmpty((String)balance)) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a", (String)"LastDayBalanceImpl_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        }
        balance = balance.replaceAll(",", "");
        balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
        balanceInfo.setAvailableBalance(new BigDecimal(balance));
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (StringUtils.isNotEmpty((String)hisBalance)) {
            hisBalance = hisBalance.replaceAll(",", "");
            balanceInfo.setLastDayAvlBalance(new BigDecimal(hisBalance));
        }
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "CebankQueryBalanceOp";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.queryLastDayBalance() && !BankBusinessConfig.isCollectAcnt(request.getAcnt().getAccNo());
    }

    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, false);
    }
}

