/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String trCode = "STTQ0101";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element Req = JDomUtils.addChild((Element)Data, (String)"Req");
        String accNo = acnt.getAccNo();
        JDomUtils.addChild((Element)Req, (String)"BASE_ACCT_NO", (String)accNo);
        JDomUtils.addChild((Element)Req, (String)"ACCT_TYPE", (String)BankBusinessConfig.getAcnoType(accNo));
        JDomUtils.addChild((Element)Req, (String)"CCY", (String)bankBalanceRequest.getBankCurrency());
        JDomUtils.addChild((Element)Req, (String)"CERTIFICATE_NO", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        return xmlMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element Packet = JDomUtils.string2Root((String)s, (String)encoding);
        Element Data = Packet.getChild("Data");
        Element Pub = Data.getChild("Pub");
        BankResponse response = TCommon.parseBankResponse(Pub);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element Res = Data.getChild("Res");
        Element ACCT_ARRAY = Res.getChild("ACCT_ARRAY");
        String CurrentBalance = ACCT_ARRAY.getChildTextTrim("LEDGER_BAL");
        String AvailBalance = ACCT_ARRAY.getChildTextTrim("AVAILABLE_BAL");
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String acno = acnt.getAccNo();
        String return_anco = ACCT_ARRAY.getChildTextTrim("BASE_ACCT_NO");
        if (!return_anco.equalsIgnoreCase(acno)) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u6c42\u67e5\u8be2\u7684\u8d26\u6237\uff08%1$s\uff09\u548c\u8fd4\u56de\u7ed3\u679c\u7684\u8d26\u6237\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), acno, return_anco);
            logger.error(resMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (!StringUtils.isEmpty((String)CurrentBalance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(CurrentBalance));
        }
        if (!StringUtils.isEmpty((String)AvailBalance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(AvailBalance));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }
}

