/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.payment.authorized;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AuthorizedQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "STDC0302";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c", (String)"AuthorizedQueryPayImpl_0", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String trCode = "STDC0302";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element REQ = JDomUtils.addChild((Element)Data, (String)"Req");
        String origMSGsID = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"origMSGsID");
        if (StringUtils.isEmpty((String)origMSGsID)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6d41\u6c34\u53f7OrigMSGsID\u4e3a\u7a7a\u3002", (String)"AuthorizedQueryPayImpl_4", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)REQ, (String)"OrigMSGsID", (String)origMSGsID);
        return JDomUtils.root2String((Element)Packet, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element packet = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element data = JDomUtils.getChildElement((Element)packet, (String)"Data");
        Element pub = JDomUtils.getChildElement((Element)data, (String)"Pub");
        String retCode = JDomUtils.getChildText((Element)pub, (String)"RetCode");
        String retMsg = JDomUtils.getChildText((Element)pub, (String)"RetMsg");
        Element res = JDomUtils.getChildElement((Element)data, (String)"Res");
        String status = JDomUtils.getChildText((Element)res, (String)"Status");
        String origMSGsID = JDomUtils.getChildText((Element)res, (String)"OrigMSGsID");
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"origMSGsID", (String)origMSGsID);
        if (!"0000".equals(retCode) && !"000000".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u4e0d\u8bc6\u522b\u8be5\u6807\u5fd7\u3002", (String)"AuthorizedQueryPayImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else if ("S".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)"");
        } else if ("A".equals(status) || "P".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)"");
        } else if ("T".equals(status) || "F".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)ResManager.loadKDString((String)"\u7533\u8bf7\u5904\u7406\u5931\u8d25", (String)"AuthorizedQueryPayImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u72b6\u6001\u4e0d\u8bc6\u522b\u3002", (String)"AuthorizedQueryPayImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

