/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxb.dc.service.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxb.dc.service.util.Packer;
import kd.ebg.aqap.banks.jxb.dc.service.util.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final Logger logger = LoggerFactory.getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead(Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"Currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"QryDir", (String)"A");
        JDomUtils.addChild((Element)body, (String)"QHTranstype", (String)"");
        JDomUtils.addChild((Element)body, (String)"pageSize", (String)"1000");
        JDomUtils.addChild((Element)body, (String)"currentIndex", (String)this.getCurrentPage());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"FIN0000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)request.getAcnt().getAccNo(), (String)StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element body = root.getChild("Body");
        Integer recordNumber = Integer.parseInt(body.getChildText("recordNumber"));
        if (recordNumber == 0) {
            detailResponse.setDetails(new ArrayList());
            this.setCurrentPage("");
            this.setLastPage(true);
            return detailResponse;
        }
        Element list = body.getChild("List");
        List records = list.getChildren("Record");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Element dto = (Element)records.get(i);
            DetailInfo detail = new DetailInfo();
            try {
                detail.setCurrency(dto.getChildTextTrim("Currency"));
                detail.setOppAccNo(dto.getChildTextTrim("YourRichNbr"));
                detail.setOppAccName(dto.getChildTextTrim("YourRichName"));
                detail.setAccName(request.getAcnt().getAccName());
                detail.setAccNo(request.getAcnt().getAccNo());
                String transferDate = dto.getChildTextTrim("AcctDate");
                String transferTime = dto.getChildTextTrim("TransTime");
                transferTime = StringUtils.isEmpty((String)transferTime) ? "000000" : transferTime.replaceAll(":", "");
                detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detail.setTransTime(LocalDateTime.parse(transferDate + transferTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                BigDecimal amount = new BigDecimal(dto.getChildTextTrim("Amount"));
                String CDFlag = dto.getChildTextTrim("TransDir");
                if (CDFlag.equalsIgnoreCase("D")) {
                    detail.setDebitAmount(amount);
                    detail.setCreditAmount(new BigDecimal(0));
                } else {
                    if (!CDFlag.equalsIgnoreCase("C")) continue;
                    detail.setDebitAmount(new BigDecimal(0));
                    detail.setCreditAmount(amount);
                }
                detail.setExplanation(dto.getChildTextTrim("Reserve80"));
                String bal = dto.getChildTextTrim("Balance");
                if (StringUtils.isNotEmpty((String)bal)) {
                    detail.setBalance(new BigDecimal(bal));
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(dto);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(dto.getChildTextTrim("TransNbr"));
                String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), transferDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                totalList.add(detail);
                continue;
            }
            catch (Exception e) {
                logger.error("\u660e\u7ec6\u6570\u636e\u6709\u8bef", (Throwable)e);
            }
        }
        String num = body.getChildText("recordNumber");
        int retRecords = Integer.parseInt(StringUtils.isEmpty((String)num) ? "0" : num);
        if (retRecords < 1000) {
            logger.info("\u5f53\u524d\u7b14\u6570\u5c0f\u4e8e1000\uff0c\u4e3a\u6700\u540e\u4e00\u9875");
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1000 + "");
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "eacqry.AcTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "eacqry.AcTrsQry", "0");
    }
}

