/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.TreeMap;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;

public class Crypto {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Crypto.class);

    public static String sign(JSONObject data) {
        String s = JSON.toJSONString((Object)JSONObject.parseObject((String)data.toJSONString(), TreeMap.class));
        try {
            byte[] bytes = Base64.getDecoder().decode(Crypto.getPlatformPri());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(privateKey);
            signature.update(s.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static JSONObject verify(String s) {
        JSONObject resp = JSON.parseObject((String)s);
        resp = resp.getJSONObject("data");
        String resp_code = resp.getString("resp_code");
        String resp_desc = resp.getString("resp_desc");
        if (!"00000000".equalsIgnoreCase(resp_code)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)resp_code, (String)resp_desc));
        }
        return resp;
    }

    public static String getPlatformPri() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("customer_pri_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)"Certificate required, please upload RSA private key.");
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return CipherInfoUtil.getKey((byte[])fileContent);
    }
}

